package com.pcloud.book.group.vo;

import com.pcloud.common.dto.BaseDto;

import java.util.List;

import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * @ClassName com.pcloud.book.group.vo.UpdateResourceColumnVO
 * @Author zhuyajie
 * @Description 资源页栏目
 * @Date 2021/3/26 17:17
 * @Version 1.0
 **/
@Data
public class ResourceColumnAndServeVO extends BaseDto{
    /**
     * 资源页id
     */
    private Long resourcePageId;
    /**
     * 资源栏目id
     */
    private Long resourcePageColumnId;
    /**
     * 栏目类型
     */
    private Integer columnType;
    /**
     * 栏目标题
     */
    private String columnName;
    /**
     * 栏目版式
     */
    private Integer columnFormat;
    /**
     * 栏目排序
     */
    private Integer columnSeq;
    /**
     * 客户端展示数量
     */
    private Integer showCount;
    /**
     * 客户端是否开启展示更多
     */
    private Integer showMore;
    /**
     * 资源列表
     */
    private List<ResourcePageItemVO> itemVOList;
    /**
     * 资源类型
     */
    private String serveType;

    /**
     * 图片位图片
     */
    private String logoUrl;
}
