package com.pcloud.book.keywords.dao;

import com.pcloud.book.group.dto.BookGroupKeywordResourceDTO;
import com.pcloud.book.group.entity.BookGroupApp;
import com.pcloud.book.group.vo.SyncKeyworsVO;
import com.pcloud.book.keywords.dto.KeywordDTO;
import com.pcloud.book.keywords.dto.KeywordResourceDTO;
import com.pcloud.book.keywords.dto.ReplyKeywordDTO;
import com.pcloud.book.keywords.entity.BookKeyword;
import com.pcloud.book.keywords.vo.KeywordVO;
import com.pcloud.book.keywords.vo.ListKeywordVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/25 11:33
 */
public interface BookKeywordDao extends BaseDao<BookKeyword> {
    
    /**
     * @Author:lili
     * @Desr:删除社群码配置关键词
     * @Date:2019/4/25 14:48
     */
    void deleteById(Long keywordId, Long partyId);

    /**
     * @Author:lili
     * @Desr:设置排序值
     * @Date:2019/4/25 14:51
     */
    void setRank(BookKeyword bookKeyword);

    /**
     * @Author:lili
     * @Desr:获取最大的排序值
     * @Date:2019/4/25 14:53
     */
    Integer getMaxRank(Long bookGroupId, Long classifyId);

    /**
     * @Author:lili
     * @Desr:获取5个关键词
     * @Date:2019/5/5 15:16
     */
    List<KeywordDTO> listFiveKeyword(Long classifyId, Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取匹配的关键词
     * @Date:2019/5/6 10:15
     */
    ReplyKeywordDTO getKeywordId(Long classifyId, Long bookGroupId, String content);

    /**
     * 获取分类下所有关键词
     */
    List<ReplyKeywordDTO> listAllKeywordByClassifyIdAndBookGroupId(Long classifyId, Long bookGroupId);

    /**
     * 根据分类ids和群ids批量获取关键词
     */
    List<ReplyKeywordDTO> getKeywordIds(List<Long> classifyIds, List<Long> bookGroupIds, String content);

    /**
     * @Author:lili
     * @Desr:校验关键词
     * @Date:2019/5/6 14:47
     */
    Boolean checkKeyword(String keywords, Long classifyId, Long bookGroupId, Long keywordId);

    /**
     * @Author:lili
     * @Desr:获取关键词基本信息
     * @Date:2019/5/6 15:03
     */
    KeywordVO getByBookKeyword(Long bookKeywordId);

    /**
     * 更新仓库值
     * @param bookKeywordId
     */
    void updateIsWarehouse(Long bookKeywordId, Long warehouseId);

    /**
     * @Author:lili
     * @Desr:获取关键词数量
     * @Date:2019/5/14 16:46
     */
    Integer getKeywordCount(Long bookGroupId, Long classifyId);

    /**
     * 根据分类id获取
     * @param classifyId
     * @return
     */
    List<ListKeywordVO> getKeywordsByClassifyId(Long classifyId, Long bookId);

    /**
    * @description 根据booGroupId获取关键词id
    * @author 戴兴
    * @date 2019/7/16 15:28
    */
    List<SyncKeyworsVO> getKeywordsIdsByBookGroupId(Long bookGroupId,Long classifyId);

    /**
    * @description 按群删除关键词
    * @author 戴兴
    * @date 2019/7/16 17:18
    */
    void deleteKeywords(Long keywordId, Long bookGroupId, Long classifyId, Long partyId);

    /**
    * @description 根据书调整关键词顺序
    * @author 戴兴
    * @date 2019/9/11 17:24
    */
    void updateRank(Long bookGroupId, Integer rank, Long partyId, Long keywordId);

    /**
     * 根据社群码id获取列表
     * @param bookGroupId
     * @return
     */
    List<KeywordDTO> getListByBookGroupId(Long bookGroupId);

    /**
     * 根据社群码id集合获取列表
     */
    List<KeywordDTO> getListByBookGroupIdsAndType(List<Long> bookGroupIds, Integer replyType);

    /**
     * 根据社群码id逻辑删除
     */
    void deleteByBookGroupIds(List<Long> bookGroupIds);

    /**
     * 社群码下资源数量（关键词及1v1配置资源）
     * @param bookGroupIds
     * @return
     */
    public Map<Long, KeywordResourceDTO> getBookGroupResourceCount(List<Long> bookGroupIds);

    /**
     * 社群码下资源列表（关键词及1v1配置资源）
     * @param bookGroupId
     * @return
     */
    public List<BookGroupKeywordResourceDTO> getBookGroupResourceList(Long bookGroupId);

    /**
     * 查询所有的作品应用类型的关键词
     */
    List<BookGroupApp> getAllAppKeyword();

    /**
     * 根据分类id获取应用关键词回复
     * @param classifyId
     * @return
     */
    List<ListKeywordVO> getAppKeywordsByClassifyId(Long classifyId, Long bookGroupId, List<Long> keywordIdList);
}
