package com.pcloud.book.keywords.dao.impl;

import com.pcloud.book.keywords.dao.SelfRobotGuideDao;
import com.pcloud.book.keywords.entity.SelfRobotGuide;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 个人号关键词引导语
 */
@Component("selfRobotGuideDao")
public class SelfRobotGuideDaoImpl extends BaseDaoImpl<SelfRobotGuide> implements SelfRobotGuideDao {

    @Override
    public void deleteByKeywordId(Long keywordId) {
        getSessionTemplate().delete(getStatement("deleteByKeywordId"), keywordId);
    }

    @Override
    public List<SelfRobotGuide> getListByKeywordId(Long keywordId) {
        return getSessionTemplate().selectList(getStatement("getListByKeywordId"), keywordId);
    }
}
