package com.pcloud.book.mq.producer;

import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.book.book.dto.BookNameUpdateDTO;
import com.pcloud.book.book.entity.Book;
import com.pcloud.book.util.common.ThreadPoolUtils;
import com.pcloud.common.core.biz.UpdateSuperSearchQueueBiz;
import com.pcloud.common.core.constant.UpdateSuperSearchCode;
import com.pcloud.common.core.dto.UpdateSuperSearchMQDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class UpdateSuperSearchProducer {

    @Autowired
    private UpdateSuperSearchQueueBiz updateSuperSearchQueueBiz;
    @Autowired
    private BookAdviserBiz bookAdviserBiz;

    public void createBook(Long bookAdviserId) {
        log.info("编辑创建图书新增超级搜索数据：{}", bookAdviserId);
        if (null == bookAdviserId) {
            return;
        }
        ThreadPoolUtils.UPDATE_SUPER_SEARCH_POOL.execute(() -> {
            UpdateSuperSearchMQDTO updateSuperSearchMQDTO = UpdateSuperSearchMQDTO.builder()
                    .superSearchCode(UpdateSuperSearchCode.BOOK_CREATE)
                    .resourceId(bookAdviserId)
                    .build();
            updateSuperSearchQueueBiz.sendMessageQueue(updateSuperSearchMQDTO);
        });
    }

    public void deleteBook(Long bookId, Long adviserId, Long channelId) {
        log.info("编辑删除图书新增超级搜索数据bookId：{}，adviserId：{}，channelId：{}", bookId, adviserId, channelId);
        if (null == bookId || null == adviserId || null == channelId) {
            return;
        }
        ThreadPoolUtils.UPDATE_SUPER_SEARCH_POOL.execute(() -> {
            BookAdviserDto bookAdviserDto = bookAdviserBiz.getBase(bookId, channelId, adviserId);
            if (null == bookAdviserDto || null == bookAdviserDto.getBookAdviserId()) {
                return;
            }
            UpdateSuperSearchMQDTO updateSuperSearchMQDTO = UpdateSuperSearchMQDTO.builder()
                    .superSearchCode(UpdateSuperSearchCode.BOOK_DELETE)
                    .resourceId(bookAdviserDto.getBookAdviserId())
                    .build();
            updateSuperSearchQueueBiz.sendMessageQueue(updateSuperSearchMQDTO);
        });
    }

    public void updateBook(Book book) {
        log.info("编辑更新图书新增超级搜索数据book：{} ",book.getBookId());
        ThreadPoolUtils.UPDATE_SUPER_SEARCH_POOL.execute(() -> {
            BookAdviserDto bookAdviserDto = bookAdviserBiz.getBase(book.getBookId(),book.getChannelId(), book.getLastModifiedUser());
            if (null == bookAdviserDto || null == bookAdviserDto.getBookAdviserId()) {
                return;
            }
            UpdateSuperSearchMQDTO updateSuperSearchMQDTO = UpdateSuperSearchMQDTO.builder()
                    .superSearchCode(UpdateSuperSearchCode.BOOK_UPDATE)
                    .resourceId(bookAdviserDto.getBookAdviserId())
                    .build();
            updateSuperSearchQueueBiz.sendMessageQueue(updateSuperSearchMQDTO);
        });
    }

    public void create(Long id) {
        log.info("编辑创建新增超级搜索数据：{}", id);
        if (null == id) {
            return;
        }
        ThreadPoolUtils.UPDATE_SUPER_SEARCH_POOL.execute(() -> {
            UpdateSuperSearchMQDTO updateSuperSearchMQDTO = UpdateSuperSearchMQDTO.builder()
                    .superSearchCode(UpdateSuperSearchCode.GROUP_QRCODE_CREATE)
                    .resourceId(id)
                    .build();
            updateSuperSearchQueueBiz.sendMessageQueue(updateSuperSearchMQDTO);
        });
    }

    public void delete(Long id) {
        log.info("编辑删除新增超级搜索数据sceneId：{}", id);
        if (null == id) {
            return;
        }
        ThreadPoolUtils.UPDATE_SUPER_SEARCH_POOL.execute(() -> {
            UpdateSuperSearchMQDTO updateSuperSearchMQDTO = UpdateSuperSearchMQDTO.builder()
                    .superSearchCode(UpdateSuperSearchCode.GROUP_QRCODE_DELETE)
                    .resourceId(id)
                    .build();
            updateSuperSearchQueueBiz.sendMessageQueue(updateSuperSearchMQDTO);
        });
    }

    public void update(Long id) {
        log.info("编辑更新新增超级搜索数据：{} ",id);
        ThreadPoolUtils.UPDATE_SUPER_SEARCH_POOL.execute(() -> {
            if (null == id) {
                return;
            }
            UpdateSuperSearchMQDTO updateSuperSearchMQDTO = UpdateSuperSearchMQDTO.builder()
                    .superSearchCode(UpdateSuperSearchCode.GROUP_QRCODE_UPDATE)
                    .resourceId(id)
                    .build();
            updateSuperSearchQueueBiz.sendMessageQueue(updateSuperSearchMQDTO);
        });
    }
}
