package com.pcloud.book.pcloudkeyword.facade;


import com.pcloud.book.pcloudkeyword.biz.PcloudRobotMemoBiz;
import com.pcloud.book.pcloudkeyword.entity.*;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@Api("备忘录")
@RestController("pcloudRobotMemo")
@RequestMapping("pcloudRobotMemoFacade")
public class PcloudRobotMemoFacade {

    @Autowired
    private PcloudRobotMemoBiz pcloudRobotMemoBiz;


    @ApiOperation("新建分组")
    @PostMapping("/createMemoGroup")
    ResponseDto<?> createMemoGroup(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("备忘录分组") PcloudRobotMemoGroup pcloudRobotMemoGroup
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotMemoBiz.createMemoGroup(pcloudRobotMemoGroup);
        return new ResponseDto<>();
    }

    @ApiOperation("修改分组")
    @PostMapping("/updateMemoGroup")
    ResponseDto<?> updateMemoGroup(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("备忘录") PcloudRobotMemoGroup pcloudRobotMemoGroup
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotMemoBiz.updateMemoGroup(pcloudRobotMemoGroup);
        return new ResponseDto<>();
    }

    @ApiOperation("删除分组")
    @PostMapping("/deleteMemoGroup")
    ResponseDto<?> deleteMemoGroup(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("备忘录Id") PcloudRobotMemoGroup pcloudRobotMemoGroup
    ) throws Exception {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if(pcloudRobotMemoGroup.getId()==1){
            throw new Exception("默认分组无法被删除");
        }
        pcloudRobotMemoBiz.deleteMemoGroupById(pcloudRobotMemoGroup.getId());
        return new ResponseDto<>();
    }

    @ApiOperation("新建备忘录")
    @PostMapping("/createPcloudRobotMemo")
    ResponseDto<?> createPcloudRobotMemo(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("备忘录") PcloudRobotMemo pcloudRobotMemo
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotMemoBiz.createPcloudRobotMemo(pcloudRobotMemo);
        return new ResponseDto<>();
    }


    @ApiOperation("修改备忘录")
    @PostMapping("/updatePcloudRobotMemo")
    ResponseDto<?> updatePcloudRobotMemo(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("备忘录") PcloudRobotMemo pcloudRobotMemo
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotMemoBiz.updatePcloudRobotMemo(pcloudRobotMemo);
        return new ResponseDto<>();
    }

    @ApiOperation("删除备忘录")
    @PostMapping("/deletePcloudRobotMemo")
    ResponseDto<?> deletePcloudRobotMemo(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("备忘录Id") PcloudRobotMemo pcloudRobotMemo
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotMemoBiz.deleteById(pcloudRobotMemo.getId());
        return new ResponseDto<>();
    }

    @ApiOperation("查询备忘录")
    @GetMapping("/getPcloudRobotMemo")
    ResponseDto<?> getPcloudRobotMemo(
            @RequestHeader("token") @ApiParam("token信息") String token
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotMemoBiz.getPcloudRobotMemo());
    }

    @ApiOperation("通过内容查询备忘录")
    @GetMapping("/getMemoByContext")
    ResponseDto<?> getMemoByContext(
            @RequestHeader("token") @ApiParam("token信息") String token,String context
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotMemoBiz.getMemoByContext(context));
    }



}
