package com.pcloud.book.personal.dao.impl;


import com.pcloud.book.personal.dao.PcloudSkillRecordDao;
import com.pcloud.book.personal.entity.PcloudSkillRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository("pcloudSkillRecordDao")
public class PcloudSkillRecordDaoImpl extends BaseDaoImpl<PcloudSkillRecord> implements PcloudSkillRecordDao {
    @Override
    public int deleteByPrimaryKey(Integer id) {
        return super.sqlSessionTemplate.delete(this.getStatement("deleteByPrimaryKey"),id);
    }

    @Override
    public int insertSelective(PcloudSkillRecord record) {
        return super.sqlSessionTemplate.insert(this.getStatement("insertSelective"),record);
    }

    @Override
    public PcloudSkillRecord selectByPrimaryKey(Integer id) {
        return super.getSessionTemplate().selectOne(this.getStatement("selectByPrimaryKey"),id);
    }

    @Override
    public int updateByPrimaryKeySelective(PcloudSkillRecord record) {
        return super.getSessionTemplate().update(this.getStatement("updateByPrimaryKeySelective"),record);
    }

    @Override
    public int updateByPrimaryKey(PcloudSkillRecord record) {
        return super.getSessionTemplate().update(this.getStatement("updateByPrimaryKey"),record);
    }

    @Override
    public PcloudSkillRecord getBySkillIdAndWxId(Integer skillId, String wxUserId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("skillId",skillId);
        paramMap.put("wxUserId",wxUserId);
        return super.getSessionTemplate().selectOne(this.getStatement("getBySkillIdAndWxId"),paramMap);
    }

    @Override
    public void updateState4ResourceAndActivity(String wxUserId, String robotId, Integer id, Integer state) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("skillId",id);
        paramMap.put("wxUserId",wxUserId);
        paramMap.put("state",state);
        super.getSessionTemplate().update(this.getStatement("updateState4ResourceAndActivity"),paramMap);
    }

    @Override
    public void batchUpdateState4ResourceAndActivity(String wxUserId, List<Long> skillIds, Integer state) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("skillIds",skillIds);
        paramMap.put("wxUserId",wxUserId);
        paramMap.put("state",state);
        super.getSessionTemplate().update(this.getStatement("batchUpdateState4ResourceAndActivity"),paramMap);

    }
}
