package com.pcloud.book.personal.dao.impl;

import com.google.common.collect.Maps;
import com.pcloud.book.personal.dao.PersonalStarRecordDao;
import com.pcloud.book.personal.dto.PersonalStarReceiveDto;
import com.pcloud.book.personal.entity.PersonalStarRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;

@Repository("personalStarRecordDao")
public class PersonalStarRecordDaoImpl extends BaseDaoImpl<PersonalStarRecord> implements PersonalStarRecordDao {
    @Override
    public Integer hasReceive(Long wechatUserId, String receiveDate, Integer type) {
        HashMap<String, Object> map = Maps.newHashMap();
        map.put("wechatUserId", wechatUserId);
        map.put("receiveDate",receiveDate);
        map.put("type",type);
        return super.getSqlSession().selectOne(getStatement("hasReceive"), map);
    }

    @Override
    public Integer getReceiveStarCount(Long wechatUserId) {
        HashMap<String, Object> map = Maps.newHashMap();
        map.put("wechatUserId", wechatUserId);
        return super.getSqlSession().selectOne(getStatement("getReceiveStarCount"), map);
    }

    @Override
    public Integer insert4Type(PersonalStarRecord personalStarRecord) {
        return super.getSqlSession().insert(getStatement("insert4Type"), personalStarRecord);
    }

    @Override
    public Integer hasReceiveFirstLogin(Long wechatUserId, Integer type) {
        HashMap<String, Object> map = Maps.newHashMap();
        map.put("wechatUserId", wechatUserId);
        map.put("type",type);
        return super.getSqlSession().selectOne(getStatement("hasReceive"), map);
    }

    @Override
    public List<PersonalStarReceiveDto> getReceiveStarCountList() {

        return getSessionTemplate().selectList(getStatement("getReceiveStarCountList"));
    }

    @Override
    public Integer getLoginDays(Long wechatUserId) {
        HashMap<String, Object> map = Maps.newHashMap();
        map.put("wechatUserId", wechatUserId);
        return super.getSqlSession().selectOne(getStatement("getLoginDays"), map);
    }

    @Override
    public Integer getTaskCount(Long wechatUserId) {
        HashMap<String, Object> map = Maps.newHashMap();
        map.put("wechatUserId", wechatUserId);
        return super.getSqlSession().selectOne(getStatement("getTaskCount"), map);
    }
}
