package com.pcloud.book.personal.facade;

import com.pcloud.book.personal.biz.PcloudUserLabelBiz;
import com.pcloud.book.personal.dto.PcloudLabelGroupDto;
import com.pcloud.book.personal.dto.PcloudUserLabelDto;
import com.pcloud.book.personal.entity.PcloudUserLabel;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.cookie.Cookie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import io.swagger.annotations.Api;

@Api("个人中心标签")
@RestController("pcloudUserLabelFacede")
@RequestMapping("pcloudUserLabel")
public class PcloudUserLabelFacede {

    @Autowired
    private PcloudUserLabelBiz pcloudUserLabelBiz;

    @RequestMapping(value = "getPcloudUserLabelList",method = RequestMethod.GET)
    public ResponseDto<List<PcloudUserLabelDto>>  getPcloudUserLabelList(@RequestParam String wxUserId){
        return new ResponseDto<List<PcloudUserLabelDto>>(pcloudUserLabelBiz.getPcloudUserLabelList(wxUserId));
    }

    @RequestMapping(value = "addPcloudUserLabel",method = RequestMethod.POST)
    public ResponseDto<?>  addPcloudUserLabel(@CookieValue("userInfo") String userInfo, @RequestBody List<PcloudUserLabel> pcloudUserLabels){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        pcloudUserLabelBiz.addPcloudUserLabel(pcloudUserLabels,wechatUserId);
        return new ResponseDto<>();
    }

    @RequestMapping(value = "deletePcloudUserLabel",method = RequestMethod.GET)
    public ResponseDto<?>  deletePcloudUserLabel(@RequestParam("id") Integer id){
        pcloudUserLabelBiz.deletePcloudUserLabel(id);
        return new ResponseDto<>();
    }

    @RequestMapping(value = "batchDeletePcloudUserLabel",method = RequestMethod.POST)
    public ResponseDto<?>  batchDeletePcloudUserLabel(@RequestBody List<Integer> ids){
        pcloudUserLabelBiz.batchDeletePcloudUserLabel(ids);
        return new ResponseDto<>();
    }

    @RequestMapping(value = "getPcloudLabelGroup",method = RequestMethod.GET)
    public ResponseDto<List<PcloudLabelGroupDto>>  getPcloudLabelGroup(){
        return new ResponseDto<List<PcloudLabelGroupDto>>(pcloudUserLabelBiz.getPcloudLabelGroup());
    }
}
