package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.dao.PersonalStageJumpKeywordDao;
import com.pcloud.book.personalstage.dto.PersonalStageJumpKeywordDto;
import com.pcloud.book.personalstage.entity.PersonalStageJumpKeyword;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("personalStageJumpKeyword")
public class PersonalStageJumpKeywordDaoImpl extends BaseDaoImpl<PersonalStageJumpKeyword> implements PersonalStageJumpKeywordDao {
    @Override
    public PersonalStageJumpKeyword getStageKeywordByKeywords(List<String> keywords, Long personalStageId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("keywords", keywords);
        paramMap.put("personalStageId", personalStageId);
        return super.getSessionTemplate().selectOne(getStatement("getStageKeywordByKeywords"), paramMap);
    }

    @Override
    public void batchInsert(List<PersonalStageJumpKeyword> personalStageJumpKeywords) {
        super.getSessionTemplate().insert(getStatement("batchInsert"), personalStageJumpKeywords);
    }

    @Override
    public void deleteByJumpId(Long jumpId) {
        super.getSqlSession().delete(getStatement("deleteByJumpId"), jumpId);
    }

    @Override
    public PersonalStageJumpKeywordDto getByKeyword(Long personalStageId, String keyword, Integer jumpType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("keyword", keyword);
        paramMap.put("personalStageId", personalStageId);
        paramMap.put("jumpType", jumpType);
        return super.getSessionTemplate().selectOne(getStatement("getByKeyword"), paramMap);
    }

    @Override
    public String getFirstKeywordByPersonalStageId(Long personalStageId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("personalStageId", personalStageId);
        return super.getSessionTemplate().selectOne(getStatement("getFirstKeywordByPersonalStageId"), paramMap);
    }
}
