package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.dto.PersonalStageProgressDTO;
import com.pcloud.book.personalstage.entity.PersonalStageProgressMessage;
import com.pcloud.book.personalstage.dao.PersonalStageProgressMessageDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.*;

/**
 * (PersonalStageProgressMessage)表数据库访问层
 *
 * @author zyq
 * @since 2020-02-24 15:57:48
 */
@Repository("personalStageProgressMessageDaoImpl")
public class PersonalStageProgressMessageDaoImpl extends BaseDaoImpl<PersonalStageProgressMessage> implements PersonalStageProgressMessageDao {

    @Override
    public List<PersonalStageProgressMessage> getPersonalProgress(Date startTime, Long progressId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("startTime",startTime);
        paramMap.put("progressId",progressId);
        return getSessionTemplate().selectList(getStatement("getPersonalProgress"),paramMap);
    }

    public List<PersonalStageProgressMessage> selectAllProgressMessage(){
        return getSessionTemplate().selectList(getStatement("selectAllProgressMessage"));
    }

    @Override
    public List<PersonalStageProgressMessage> getProgressMessageList(Integer progressId) {
        return getSessionTemplate().selectList(getStatement("getProgressMessageList"),progressId);
    }

    @Override
    public void deleteAll() {
        super.getSessionTemplate().delete(getStatement("deleteAll"));
    }

    @Override
    public Integer countProgressMessage(Long progressId) {
        return super.sqlSessionTemplate.selectOne(getStatement("countProgressMessage"),progressId);
    }

    @Override
    public PersonalStageProgressMessage getWaitClickProgress(Integer progressId) {
        return getSessionTemplate().selectOne(getStatement("getWaitClickProgress"),progressId);
    }

    @Override
    public List<PersonalStageProgressDTO> getProgressList() {
        return getSessionTemplate().selectList(getStatement("getProgressList"));
    }

    @Override
    public void deleteByProgressId(Integer progressId) {
        super.getSessionTemplate().delete(getStatement("deleteByProgressId"),progressId);
    }
}