package com.pcloud.book.push.dao;

import com.pcloud.book.push.entity.SelfPushItem;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @描述：个人号群发项
 * @作者：zhuyajie
 * @创建时间：18:59 2019/11/26
 * @版本：1.0
 */
public interface SelfPushItemDao extends BaseDao<SelfPushItem>{

    /**
     * 更新群发状态
     * @param pushStatus
     * @param pushId
     */
    public void updatePushStatusByPushId(Integer pushStatus, Long pushId);

    /**
     * 查群发项列表
     * @param pushId
     * @return
     */
    List<SelfPushItem> getByPushId(Long pushId);

    public void deleteByPushId(Long pushId);

    Integer getStatusByPushId(Long pushId);

    List<SelfPushItem> getByPushIds(List<Long> pushIds);
}
