package com.pcloud.book.push.dto;


import com.pcloud.book.base.dto.ReplyParamDTO;
import com.pcloud.book.push.entity.SelfPushItem;
import lombok.Data;

import java.util.List;


/**
 * @描述：个人号群发新增
 * @作者：zhuyajie
 * @创建时间：9:49 2019/11/27
 * @版本：1.0
 */
@Data
public class SelfPushAddParamDTO {

    /**
     * 个人号群发id
     */
    private Long pushId;

    /**
     * 推送小号id
     */
    private String altId;

    /**
     * 推送用户id
     */
    private List<String> userIdList;

    /**
     * 统一入参
     */
    private List<ReplyParamDTO> replyParamDTOS;

    private List<SelfPushItem> pushItemList;
    /**
     * 立即发送
     */
    private Boolean sendNow;
    /**
     * 发送时间
     */
    private String sendTime;
    /**
     * 开始时间
     */
    private  String startTime;
    /**
     * 结束时间
     */
    private String endTime;
    /**
     推送时间类型（1:每天发送 2:每周发送）
     */
    private Integer pushType;
    /**
     *周几
     */
    private String weekDays;


    private String systemCode;

    private Long bookGroupId;

    /**
     * 是否发送所有好友
     */
    private Boolean sendAll;
    /**
     * 个人号类型（1微信2QQ）
     */
    private Integer altType;

}
