package com.pcloud.book.record.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.record.biz.IpDataBiz;
import com.pcloud.book.record.entity.IpData;
import com.pcloud.book.record.entity.IpData4Third;
import com.pcloud.book.record.entity.IpResponse;
import com.pcloud.book.record.mapper.IpDataMapper;
import com.pcloud.book.util.common.HttpUtils;
import com.pcloud.common.utils.json.JSONUtils;
import com.pcloud.common.utils.string.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author guiq
 * @since 2020年8月21日
 */
@Service
@Slf4j
public class IpDataBizImpl implements IpDataBiz {

    private static final String HOST = "https://api01.aliyun.venuscn.com";
    private static final String PATH = "/ip";
    private static final String METHOD = "GET";


    @Autowired
    private IpDataMapper ipDataMapper;
    @Value("${ip.appcode}")
    private String appCode;

    @Override
    public IpData getAreaByIp(String ipAddress) {
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + appCode);
        Map<String, String> queries = new HashMap<String, String>();
        queries.put("ip", ipAddress);
        //先从数据库查询，没有再查询第三方
        IpData ipData = ipDataMapper.selectByIp(ipAddress);
        if (null == ipData) {
            try {
                HttpResponse response = HttpUtils.doGet(HOST, PATH, METHOD, headers, queries);
                log.info("查询ip返回的数据是response：{}", response);
                String entityString = EntityUtils.toString(response.getEntity());
                IpResponse ipResponse;
                if (StringUtil.isEmpty(entityString)) {
                    return null;
                }
                ipResponse = JSONUtils.jsonToBean(entityString, IpResponse.class);
                if (null == ipResponse || null == ipResponse.getData()) {
                    return null;
                }
                IpData4Third ipData4Third = ipResponse.getData();
                if (!Objects.equals("200", ipResponse.getRet())) {
                    return null;
                }
                if (null == ipData4Third || null == ipData4Third.getCity_id()) {
                    return null;
                }
                ipData = new IpData();
                ipData.setIp(ipAddress);
                ipData.setRegion(ipData4Third.getRegion());
                ipData.setRegionId(ipData4Third.getRegion_id());
                ipData.setCity(ipData4Third.getCity());
                ipData.setCityId(ipData4Third.getCity_id());
                ipDataMapper.insert(ipData);
            } catch (Exception e) {
                log.error("获取ip失败，ip：{}", ipAddress);
             }
        }
        return ipData;
    }

}
