package com.pcloud.book.riddle.dao;

import com.pcloud.book.riddle.dto.GroupRiddleDTO;
import com.pcloud.book.riddle.dto.UserRankingDTO;
import com.pcloud.book.riddle.entity.RiddleRecord;
import com.pcloud.common.core.dao.BaseDao;

import java.util.Date;
import java.util.List;

/**
 * @描述：猜谜记录
 * @作者：zhuyajie
 * @创建时间：18:18 2019/7/24
 * @版本：1.0
 */
public interface RiddleRecordDao extends BaseDao<RiddleRecord> {


    /**
     * 获取上一条猜谜记录
     * @param wxGroupId
     * @param status 状态
     * @return
     */
    RiddleRecord getLastRecordByWxGroupId(String wxGroupId, Integer status);

    /**
     * 获得答对题目数量
     * @param wxGroupId
     * @return
     */
    Integer getCorrectCountByGroup(String wxGroupId, Integer finishCount);

    /**
     * 获取参与次数、人数
     * @param wxGroupId
     * @return
     */
    public GroupRiddleDTO getParticipateCount(String wxGroupId);

    /**
     * 获得群排名
     * @param wxGroupId
     * @return
     */
    public Integer getGroupRanking(String wxGroupId);

    /**
     * 获得用户答题排名
     * @param wxGroupId
     * @return
     */
    public List<UserRankingDTO> getUserRanking(String wxGroupId, Date createTime);

    /**
     * 根据时间查答对题数
     * @param wxGroupId
     * @param createTime
     * @return
     */
    public Integer getCorrectCountByTime(String wxGroupId, Date createTime);

    /**
     * 连答对5题过关次数
     * @param wxGroupId
     * @return
     */
    public Integer getOverTime(String wxGroupId);

    /**
     * 获得答对过题目群数
     * @return
     */
    public Integer getCorrectGroupCount();
}
