package com.pcloud.book.riddle.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 猜谜语自定义优惠券
 */
public class RiddleCoupon extends BaseEntity{

    /**
     *商品名称
     */
    private String title;
    /**
     *商品主图
     */
    private String pictUrl;
    /**
     *商品原价
     */
    private BigDecimal zkFinalPrice;
    /**
     *优惠券价格
     */
    private BigDecimal couponPrice;
    /**
     *券后价
     */
    private BigDecimal afterCouponPrice;
    /**
     *领取链接
     */
    private String couponClickUrl;
    /**
     *类型（1：淘宝2：京东3：当当）
     */
    private Integer type;
    /**
     *创建人
     */
    private Long createUser;
    /**
     *创建时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    /**
     *修改时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date updateTime;

    /**
     *是否开启自定义优惠券
     */
    private Boolean status;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public String getPictUrl() {
        return pictUrl;
    }

    public void setPictUrl(String pictUrl) {
        this.pictUrl = pictUrl == null ? null : pictUrl.trim();
    }

    public BigDecimal getZkFinalPrice() {
        return zkFinalPrice;
    }

    public void setZkFinalPrice(BigDecimal zkFinalPrice) {
        this.zkFinalPrice = zkFinalPrice;
    }

    public BigDecimal getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(BigDecimal couponPrice) {
        this.couponPrice = couponPrice;
    }

    public BigDecimal getAfterCouponPrice() {
        return afterCouponPrice;
    }

    public void setAfterCouponPrice(BigDecimal afterCouponPrice) {
        this.afterCouponPrice = afterCouponPrice;
    }

    public String getCouponClickUrl() {
        return couponClickUrl;
    }

    public void setCouponClickUrl(String couponClickUrl) {
        this.couponClickUrl = couponClickUrl == null ? null : couponClickUrl.trim();
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getStatus() {
        return status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }
}