package com.pcloud.book.rightsSetting.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.applet.entity.AppletThirdResources;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 权益banner(RightsSettingBanner)实体类
 *
 * @author makejava
 * @since 2021-03-17 14:15:05
 */
@Data
public class RightsSettingBanner extends BaseEntity {

    private static final long serialVersionUID = -14857612347642124L;

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("权益id")
    private Long rightsSettingId;

    @ApiModelProperty("1 大图    2 小图")
    private Integer bannerType;

    @ApiModelProperty("banner标题")
    private String bannerTitle;

    @ApiModelProperty("跳转类型（1指定页面2web页面3应用作品4资讯资源）")
    private String bannerPic;

    @ApiModelProperty("`jump_type` int(2) DEFAULT NULL COMMENT '跳转类型（1指定页面2web页面3应用作品4资讯资源5小程序6第三方资源）',")
    private Integer jumpType;

    @ApiModelProperty("跳转地址")
    private String jumpUrl;

    @ApiModelProperty("应用作品id")
    private Long serveId;

    @ApiModelProperty("资讯1 | 作品6 | 应用5")
    private Integer serveType;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("应用或作品对象")
    private RightsNowItem guideAppItem;

    @ApiModelProperty("咨询对象")
    private RightsNowItem guideNewsItem;

    @ApiModelProperty("第三方资源")
    private AppletThirdResources thirdResource;

}