package com.pcloud.book.rightsSetting.enums;

/**
 * @描述：权益类型-
 * @作者：zhuyajie
 * @创建时间：17:36 2020/4/19
 * @版本：1.0
 */
public enum RightsWeekTypeEnum {
    //每周、长期权益添加到立享权益中

    /**
     * 7线上学习/阅读提醒
     */
    ONLINE_REMIND(7,"线上学习/阅读提醒"),

    /**
     * 8线上读书活动
     */
    ONLINE_READING_ACTIVITY(8,"线上读书活动"),
    /**
     * 9书单推荐
     */
    BOOK_RECOMMEND(9,"书单推荐"),
    /**
     * 10资讯推送
     */
    NEWS_PUSH(10,"资讯推送"),

    /**
     * 11亲子活动设计
     */
    FAMILY_ACTIVITY(11,"亲子活动设计"),

    /**
     * 12线上精品课
     */
    ONLINE_QUALITY_COURSE(12,"线上精品课"),
    /**
     *13线下读书活动推荐
     */

    OFFLINE_READING_ACTIVITY(13,"线下读书活动推荐"),
    /**
     * 14抢兑课程/实物礼品
     */
    COURSE_OR_GIFT(14,"抢兑课程/实物礼品");


    public final Integer key;
    public final String value;


    RightsWeekTypeEnum(Integer key, String value) {
        this.value = value;
        this.key = key;
    }

    public static String getValue(Integer key) {
        for (RightsWeekTypeEnum typeEnum : RightsWeekTypeEnum.values()) {
            if (typeEnum.getKey().equals(key)) {
                return typeEnum.getValue();
            }
        }
        return null;
    }

    public Integer getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }
}
