package com.pcloud.book.skill.dao.impl;

import com.pcloud.book.skill.dao.PcloudSubReplyDao;
import com.pcloud.book.skill.entity.PcloudSubReply;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudSubReplyDao")
public class PcloudSubReplyDaoImpl extends BaseDaoImpl<PcloudSubReply> implements PcloudSubReplyDao {
    @Override
    public Integer batchInsert(List<PcloudSubReply> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public void deleteByPcloudSkillId(Long pcloudSkillId) {
        super.getSqlSession().delete(getStatement("deleteByPcloudSkillId"), pcloudSkillId);
    }

    @Override
    public List<PcloudSubReply> getListByPcloudSkillId(Long pcloudSkillId) {
        return super.getSqlSession().selectList(getStatement("getListByPcloudSkillId"), pcloudSkillId);
    }

    @Override
    public List<PcloudSubReply> getListByPcloudSkillIds(List<Long> pcloudSkillIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("pcloudSkillIds",pcloudSkillIds);
        return super.getSqlSession().selectList(getStatement("getListByPcloudSkillIds"), map);
    }

    @Override
    public List<PcloudSubReply> getBySkillIdAndType(Long skillId, Integer subType) {
        Map<String,Object> map = new HashMap<>();
        map.put("skillId", skillId);
        map.put("subType", subType);
        return getSqlSession().selectList(getStatement("getBySkillIdAndType"), map);
    }
}
