package com.pcloud.book.skill.facade;

import com.pcloud.book.skill.biz.PcloudResourceBiz;
import com.pcloud.book.skill.entity.PcloudResource;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api("技能-配置资源")
@RestController("pcloudResourceFacade")
@RequestMapping("pcloudResource")
public class PcloudResourceFacade {

    @Resource
    private PcloudResourceBiz pcloudResourceBiz;

    @ApiOperation("新增资源")
    @PostMapping("saveResource")
    public ResponseDto<Void> savePcloudResource(@RequestHeader("token") String token, @RequestBody PcloudResource pcloudResource)  throws BizException, PermissionException {
        pcloudResourceBiz.savePcloudResource(pcloudResource);
        return new ResponseDto<>();
    }

    @ApiOperation("更新资源")
    @PostMapping("updatePcloudResource")
    public ResponseDto<Void> updatePcloudResource(@RequestHeader("token") String token, @RequestBody PcloudResource pcloudResource)  throws BizException, PermissionException  {
        pcloudResourceBiz.updatePcloudResource(pcloudResource);
        return new ResponseDto<>();
    }

    @ApiOperation("删除资源")
    @GetMapping("/deletePcloudResource")
    public ResponseDto<?> deletePcloudResource(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("id") @ApiParam("资源id") Long id
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudResourceBiz.deletePcloudResource(id);
        return new ResponseDto<>();
    }

    @ApiOperation("获取资源")
    @GetMapping("/getPcloudResource")
    public ResponseDto<?> getPcloudResource(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("id") @ApiParam("资源id") Long id
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudResourceBiz.getPcloudResource(id));
    }

    @ApiOperation("获取资源列表")
    @GetMapping("/getPcloudResourceList")
    public ResponseDto<?> getPcloudResourceList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "name",required = false) @ApiParam("资源名称") String name,
            @RequestParam(value = "proLabelId",required = false) @ApiParam("专业") Long proLabelId,
            @RequestParam(value = "depLabelId",required = false) @ApiParam("深度") Long depLabelId,
            @RequestParam(value = "purLabelId", required = false) @ApiParam("目的") Long purLabelId,
            @RequestParam(value = "currentPage", defaultValue = "0") @ApiParam("当前页") Integer currentPage,
            @RequestParam(value = "numPerPage", defaultValue = "10") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudResourceBiz.getPcloudResourceList(name, proLabelId, depLabelId, purLabelId, currentPage,numPerPage));
    }
}
