package com.pcloud.book.timecontrol.mapper;


import com.pcloud.book.timecontrol.entity.TimeControlTaskPrize;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("taskPrizeMapper")
public interface TaskPrizeMapper {
    /**
     * 新增
     * @param model
     * @return
     */
    int insert(TimeControlTaskPrize model);

    TimeControlTaskPrize selectByPrimaryKey(Integer id);

    /**
     * 根据taskId和类型查询奖励
     * @param taskId
     * @param type
     * @return
     */
    TimeControlTaskPrize getByTaskId(@Param("taskId") Integer taskId, @Param("type") Integer type);

    List<TimeControlTaskPrize> listByTaskId(@Param("taskId") Integer taskId, @Param("type") Integer type);

    int updateByPrimaryKeySelective(TimeControlTaskPrize model);

    /**
     * 根据任务和类型删除
     * @param taskId
     * @param type
     */
    void deleteByTaskId(@Param("taskId") Integer taskId, @Param("type") Integer type);

    /**
     * 根据taskItemId删除奖励
     * @param taskItemId
     */
    void deleteByTaskItemId(Integer taskItemId);

    /**
     * 根据taskItemId获取单次任务奖励
     * @param taskItemId
     * @return
     */
    TimeControlTaskPrize selectByTaskItemId(Integer taskItemId);

    /**
     *获取配置奖励的单次任务
     */
    List<Integer> getConfigItemId(@Param("taskItemIds") List<Integer> taskItemIds);

    /**
     * 获取所有开关的关闭的单次任务
     * @param taskItemIds
     * @return
     */
    List<Integer> getAllCloseItemId(@Param("taskItemIds") List<Integer> taskItemIds);

    TimeControlTaskPrize getByTaskItemId(Integer taskItemId);

    TimeControlTaskPrize getByType(@Param("id") Integer id, @Param("type") Integer type);

}
