package com.pcloud.book.timecontrol.vo.request;

import com.pcloud.book.timecontrol.entity.TimeControlPrizeItem;
import com.pcloud.book.timecontrol.enums.TaskPrizeItemTypeEnum;
import com.pcloud.common.utils.bean.BeanUtils;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class AppRequestVO {
    @NotNull(message = "课程标题不能为空")
    private String content;
    @NotNull(message = "课程封面图不能为空")
    private String picUrl;
    @NotNull(message = "课程应用id不能为空")
    private Long serveId;
    @NotNull(message = "课程类型不能为空")
    private String serveType;
    /**
     * 课程链接
     */
    private String linkUrl;
    /**
     * 课程简介
     */
    private String description;

    public static TimeControlPrizeItem valueToPrizeItem(SavePrize4TaskItemVO savePrize4TaskItemVO){
        TimeControlPrizeItem prizeItem = new TimeControlPrizeItem();
        AppRequestVO vo = savePrize4TaskItemVO.getApp();
        BeanUtils.copyProperties(vo, prizeItem);
        prizeItem.setTaskId(savePrize4TaskItemVO.getTaskId());
        prizeItem.setTaskItemId(savePrize4TaskItemVO.getTaskItemId());
        prizeItem.setPrizeType(TaskPrizeItemTypeEnum.APP.key);
        prizeItem.setCreateTime(new Date());
        return prizeItem;
    }

}
