package com.pcloud.book.weixinclock.dao.impl;

import com.pcloud.book.weixinclock.dao.WeixinClockPraiseDao;
import com.pcloud.book.weixinclock.dto.GetByMemberAndUserDto;
import com.pcloud.book.weixinclock.dto.ListWeixinClockRankDto;
import com.pcloud.book.weixinclock.dto.RankDto;
import com.pcloud.book.weixinclock.entity.WeixinClockPraise;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Describe: 打卡点赞dao实现类
 * @Author: zhangdongwei
 * @Date: Create on 17:20 2019/10/22 0022
 */
@Repository("weixinClockPraise")
public class WeixinClockPraiseDaoImpl extends BaseDaoImpl<WeixinClockPraise> implements WeixinClockPraiseDao {
    @Override
    public WeixinClockPraise getByMemberAndUser(GetByMemberAndUserDto dto){
        return super.sqlSessionTemplate.selectOne(getStatement("getByMemberAndUser"), dto);
    }

    @Override
    public List<WeixinClockPraise> getMemberPraise(ListWeixinClockRankDto dto) {
        return super.sqlSessionTemplate.selectList(getStatement("getMemberPraise"), dto);
    }

    @Override
    public Integer getPraiseNum(String wechatGroupId, String wxUserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("wechatGroupId", wechatGroupId);
        paramMap.put("wxUserId", wxUserId);
        return super.sqlSessionTemplate.selectOne(getStatement("getPraiseNum"), paramMap);
    }

    @Override
    public List<WeixinClockPraise> listByWxUserId(String wechatGroupId, String wxUserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("wechatGroupId", wechatGroupId);
        paramMap.put("wxUserId", wxUserId);
        return super.sqlSessionTemplate.selectList(getStatement("listByWxUserId"), paramMap);
    }

    @Override
    public List<RankDto> listAll() {
        return super.sqlSessionTemplate.selectList(getStatement("listAll"));
    }
}
