package com.pcloud.common.core.aspect;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LFU<K, V> {
    private final int capcity;

    private Map<K, V> cache = new ConcurrentHashMap<>();

    private Map<K, HitRate> count = new ConcurrentHashMap<>();

    public LFU(int capcity) {
        this.capcity = capcity;
    }

    public Map<K, HitRate> getHotKeyMap() {
        Map<K, HitRate> count = this.count;
        return count;
    }

    public void put(K key, V value) {
        V v = cache.get(key);
        if (v == null) {
            if (cache.size() == capcity) {
                removeElement();
            }
            count.put(key, new HitRate(key, 1, System.nanoTime(), value));
        } else {
            addHitCount(key);
        }
        cache.put(key, value);
    }

    public V get(K key) {
        V value = cache.get(key);
        if (value != null) {
            addHitCount(key);
            return value;
        }
        return null;
    }

    //移除元素
    private void removeElement() {
        HitRate hr = Collections.min(count.values());
        cache.remove(hr.key);
        count.remove(hr.key);
    }

    //更新访问元素状态
    private void addHitCount(K key) {
        HitRate hitRate = count.get(key);
        hitRate.hitCount = hitRate.hitCount + 1;
        hitRate.lastTime = System.nanoTime();
    }

    //内部类
    class HitRate implements Comparable<HitRate> {
        private K key;
        private V v;
        private int hitCount;
        private long lastTime;

        private HitRate(K key, int hitCount, long lastTime, V v) {
            this.key = key;
            this.hitCount = hitCount;
            this.lastTime = lastTime;
            this.v = v;
        }

        @Override
        public int compareTo(HitRate o) {
            int compare = Integer.compare(this.hitCount, o.hitCount);
            return compare == 0 ? Long.compare(this.lastTime, o.lastTime) : compare;
        }

        public K getKey() {
            return key;
        }

        public V getV() {
            return v;
        }

        public int getHitCount() {
            return hitCount;
        }

    }
}
