package com.pcloud.common.core.biz;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.FundMessageDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @author PENG
 * @version 1.0
 * @description 基金资源变更记录消息队列实现类
 * @date 2017年10月18日 下午2:11:52
 */
@Component("fundQueueBiz")
public class FundQueueBizImpl implements FundQueueBiz {

	/**
	 * logger
	 */
	private final static Logger logger = LoggerFactory.getLogger(FundQueueBizImpl.class);

	@Autowired
	private AmqpTemplate amqpTemplate;

	/**
	 * 发送队列
	 */
	@Override
	@ParamLog("发送基金资源变更记录消息QUEUE")
	public void sendFundMessage(FundMessageDto fundMessageDto) throws BizException {
		try {
			amqpTemplate.convertAndSend(MQQueueConstant.FUND, fundMessageDto);
		} catch (Exception e) {
			logger.error("发送失败，" + e.getMessage() + "," + fundMessageDto.toString(), e);
			throw BizException.SEND_QUEUE_FAIL;
		}
	}
}
