package com.pcloud.common.shadow;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * Created by TianChao on 2017/10/24.
 */
public class RecordDto implements Serializable{


    private static final long serialVersionUID = -2187923387716975875L;

    private String path;

    private long permissionId;
    private String ipAddress;
    private int state;
    private int recordType;
    private long duration;

    private int clientCode;
    private int browserType;
    private String browserName;
    private String userAgent;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date startTime;

    Long partyId;
    Long userId;
    String partyRole;

    public long getDuration() {
        return duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Long getPartyId() {
        return partyId;
    }

    public void setPartyId(Long partyId) {
        this.partyId = partyId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getPartyRole() {
        return partyRole;
    }

    public void setPartyRole(String partyRole) {
        this.partyRole = partyRole;
    }

    private Map<String,Object>param;

    public int getRecordType() {
        return recordType;
    }

    public void setRecordType(int recordType) {
        this.recordType = recordType;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getPermissionId() {
        return permissionId;
    }

    public void setPermissionId(long permissionId) {
        this.permissionId = permissionId;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public Map<String, Object> getParam() {
        return param;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }


    public String getIpAddress() {
        return ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getClientCode() {
        return clientCode;
    }

    public void setClientCode(int clientCode) {
        this.clientCode = clientCode;
    }

    public int getBrowserType() {
        return browserType;
    }

    public void setBrowserType(int browserType) {
        this.browserType = browserType;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getBrowserName() {
        return browserName;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    public Date getStartTime() {
        return startTime;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Override
    public String toString() {
        return "RecordDto{" +
                "path='" + path + '\'' +
                ", permissionId=" + permissionId +
                ", ipAddress='" + ipAddress + '\'' +
                ", state=" + state +
                ", recordType=" + recordType +
                ", duration=" + duration +
                ", clientCode=" + clientCode +
                ", browserType=" + browserType +
                ", partyId=" + partyId +
                ", userId=" + userId +
                ", partyRole='" + partyRole + '\'' +
                ", userAgent='" + userAgent + '\'' +
                ", param=" + param +
                '}';
    }
}
