package com.pcloud.common.utils;

import java.util.List;

import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.string.StringUtil;

public class ParamChecker {

	//private static final Logger LOGGER = LoggerFactory.getLogger(ParamChecker.class);
		
	public static void checkNumberIsNull(Number number, String excepMsg) throws BizException {
		if (number==null) {
			throw new BizException(BizException.PARAM_DELETION.getCode(), excepMsg);
		}
	}
	
	public static void checkBooleanIsNull(Boolean boolean1, String excepMsg) throws BizException {
		if (boolean1==null) {
			throw new BizException(BizException.PARAM_DELETION.getCode(), excepMsg);
		}
	}
	
	public static void checkStringIsEmpty(String string, String excepMsg) throws BizException {
		if (StringUtil.isEmpty(string)) {
			throw new BizException(BizException.PARAM_DELETION.getCode(), excepMsg);
		}
	}
	
	public static void checkObjectIsNull(Object object, String excepMsg) throws BizException {
		if (object==null) {
			throw new BizException(BizException.PARAM_DELETION.getCode(), excepMsg);
		}
	}
	
	public static void checkListIsEmpty(List<?> list, String excepMsg) throws BizException {
		if (list==null || list.size()==0) {
			throw new BizException(BizException.PARAM_DELETION.getCode(), excepMsg);
		}
	}
	
	public static void checkPageParamIsAbsent(Integer currentPage, Integer numPerPage, String excepMsg) throws BizException {
		if (currentPage==null||numPerPage==null||currentPage<0||numPerPage<1){
			throw new BizException(BizException.PARAM_DELETION.getCode(), excepMsg);
		}
	} 
	
	public static boolean pageParamIsAbsent(Integer currentPage, Integer numPerPage) {
		return (currentPage==null||numPerPage==null||currentPage<0||numPerPage<1)?true:false;
	}
		
}
