package com.pcloud.book.book.dto;

import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 书刊分析DTO
 */
public class BookAnlysicsDto extends BaseDto {

    @ApiModelProperty("图书ID")
    private Long bookId;
    @ApiModelProperty("图书名字")
    private String bookName;
    @ApiModelProperty("出版ID")
    private Long agentId;
    @ApiModelProperty("出版名字")
    private String agentName;
    @ApiModelProperty("运营平台ID")
    private Long channelId;
    @ApiModelProperty("运营平台名字")
    private String channelName;
    @ApiModelProperty("编辑ID")
    private Long adviserId;
    @ApiModelProperty("编辑名字")
    private String adviserName;
    @ApiModelProperty("分类ID")
    private Long templetId;
    @ApiModelProperty("分类名字")
    private String templeName;
    @ApiModelProperty("是否基金书籍")
    private Boolean isFundSupport;
    @ApiModelProperty("关联二维码数量")
    private Long sceneCount;
    @ApiModelProperty("")
    private Long scanQR;
    @ApiModelProperty("浏览量")
    private Long scanNum;
    @ApiModelProperty("读者量")
    private Long readerNum;
    @ApiModelProperty("累计收益")
    private BigDecimal income;
    @ApiModelProperty("ISBN")
    private String isbn;
    @ApiModelProperty("扫码平均转化率")
    private Double scvr;
    @ApiModelProperty("是否主编辑")
    private Boolean isMainEditor;

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public String getAdviserName() {
        return adviserName;
    }

    public void setAdviserName(String adviserName) {
        this.adviserName = adviserName;
    }

    public Long getTempletId() {
        return templetId;
    }

    public void setTempleId(Long templetId) {
        this.templetId = templetId;
    }

    public String getTempleName() {
        return templeName;
    }

    public void setTempleName(String templeName) {
        this.templeName = templeName;
    }

    public Long getSceneCount() {
        return sceneCount;
    }

    public void setSceneCount(Long sceneCount) {
        this.sceneCount = sceneCount;
    }

    public Long getScanQR() {
        return scanQR;
    }

    public void setScanQR(Long scanQR) {
        this.scanQR = scanQR;
    }

    public Long getScanNum() {
        return scanNum;
    }

    public void setScanNum(Long scanNum) {
        this.scanNum = scanNum;
    }

    public Long getReaderNum() {
        return readerNum;
    }

    public void setReaderNum(Long readerNum) {
        this.readerNum = readerNum;
    }

    public BigDecimal getIncome() {
        return income;
    }

    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public Double getScvr() {
        return scvr;
    }

    public void setScvr(Double scvr) {
        this.scvr = scvr;
    }

    public Boolean getIsMainEditor() {
        return isMainEditor;
    }

    public void setIsMainEditor(Boolean isMainEditor) {
        this.isMainEditor = isMainEditor;
    }

    public Boolean getIsFundSupport() {
        return isFundSupport;
    }

    public void setIsFundSupport(Boolean isFundSupport) {
        this.isFundSupport = isFundSupport;
    }

    @Override
    public String toString() {
        return "BookAnlysicsDto{" +
                "bookId=" + bookId +
                ", bookName='" + bookName + '\'' +
                ", agentId=" + agentId +
                ", agentName='" + agentName + '\'' +
                ", channelId=" + channelId +
                ", channelName='" + channelName + '\'' +
                ", adviserId=" + adviserId +
                ", adviserName='" + adviserName + '\'' +
                ", templetId=" + templetId +
                ", templeName='" + templeName + '\'' +
                ", isFundSupport=" + isFundSupport +
                ", sceneCount=" + sceneCount +
                ", scanQR=" + scanQR +
                ", scanNum=" + scanNum +
                ", readerNum=" + readerNum +
                ", income=" + income +
                ", isbn='" + isbn + '\'' +
                ", scvr=" + scvr +
                ", isMainEditor=" + isMainEditor +
                '}';
    }
}
