package com.pcloud.book.advertising.enums;

/**
 * Description 广告结算方式
 * Created by PENG on 2019/4/26.
 */
public enum SettlementMethodEnum {

    CPC("CPC", "按点击量"),
    CPM("CPM", "按曝光量"),
    CPA("CPA", "按实际行动"),
    CPS("CPS", "按实际销售");

    public final String code;

    public final String name;

    SettlementMethodEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByCode(String code) {
        SettlementMethodEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            SettlementMethodEnum methodEnum = var1[var3];
            if (methodEnum.code.equals(code)) {
                return methodEnum.name;
            }
        }
        return null;
    }

    public static final String[] SETTLEMENT_METHOD_GATHER = {CPC.code, CPM.code, CPA.code, CPS.code};

    public static final String[] SETTLEMENT_METHOD_NEED_PRICE_GATHER = {CPC.code, CPM.code, CPA.code};
}
