package com.pcloud.book.reading.dao.impl;

import com.pcloud.book.reading.dao.ReadingGroupDao;
import com.pcloud.book.reading.entity.ReadingGroup;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：活动关联群
 * @作者：zhuyajie
 * @创建时间：15:30 2020/1/15
 * @版本：1.0
 */
@Component("readingGroupDao")
public class ReadingGroupDaoImpl extends BaseDaoImpl<ReadingGroup> implements ReadingGroupDao {


    @Override
    public List<ReadingGroup> getByActivityId(Long activityId) {
        return getSessionTemplate().selectList(getStatement("getByActivityId"), activityId);
    }

    @Override
    public ReadingGroup getByWxGroupId(String wxGroupId) {
        return getSessionTemplate().selectOne(getStatement("getByWxGroupId"), wxGroupId);
    }

    @Override
    public void updateWxGroupIdById(String wxGroupId, Long id) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxGroupId", wxGroupId);
        map.put("id", id);
        getSessionTemplate().update(getStatement("updateWxGroupIdById"), map);
    }

    @Override
    public ReadingGroup getLatestNullGroup(String altId) {
        return getSessionTemplate().selectOne(getStatement("getLatestNullGroup"), altId);
    }

    @Override
    public List<ReadingGroup> getAllByActivityId(Long activityId) {
        return getSessionTemplate().selectList(getStatement("getAllByActivityId"), activityId);
    }

    @Override
    public void updateGroupName(String wxGroupName, Long id) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxGroupName", wxGroupName);
        map.put("id", id);
        getSessionTemplate().update(getStatement("updateGroupName"), map);
    }
}
