package com.pcloud.common.core.dto;

import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import lombok.Data;

/**
 * @ClassName com.pcloud.common.core.dto.AppletTemplateMessageDto
 * @Author ZhengYongQiang
 * @Description 小程序模板消息
 * @Date 2020/5/9 14:12
 * @Version 1.0
 **/
@Data
public class AppletTemplateMessageDto implements Serializable {

    @ApiModelProperty("渠道id")
    private Long accountSettingId;

    @ApiModelProperty("小程序用户id")
    private Long wechatUserId;

    @ApiModelProperty("模板code")
    private String tempalteTypeCode;

    @ApiModelProperty("跳转的小程序页面路由，不填不跳转")
    private String page;

    @ApiModelProperty("模板消息键值对")
    private Map<String, String> data;

    /**
     * 结构转换
     * @return
     */
    public Map<String, Map<String, String>> convertData(){
        if(data == null || data.size() == 0){
            return new HashMap<>();
        }
        Map<String, Map<String, String>> mapData = Maps.newHashMapWithExpectedSize(data.size());
        Map<String, String> tempMap;
        for (String key : data.keySet()){
            tempMap = Maps.newHashMapWithExpectedSize(1);
            tempMap.put("value", data.get(key));
            mapData.put(key, tempMap);
        }
        return mapData;
    }

}
