package com.pcloud.common.core.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/9/26 17:01
 **/
@ApiModel("文件压缩包基础信息")
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class FileRarBaseDto implements Serializable {

    private static final long serialVersionUID = -1794097417651170567L;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("大小")
    private Long size;

    @ApiModelProperty("压缩包集合")
    private List<FileRarDto> fileRarDtos;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getSize() {
        return size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public List<FileRarDto> getFileRarDtos() {
        return fileRarDtos;
    }

    public void setFileRarDtos(List<FileRarDto> fileRarDtos) {
        this.fileRarDtos = fileRarDtos;
    }

    @Override
    public String toString() {
        return "FileRarBaseDto{" +
                "name='" + name + '\'' +
                ", size=" + size +
                ", fileRarDtos=" + fileRarDtos +
                '}';
    }
}
