/**
 *
 */
package com.pcloud.common.enums;

import java.util.Arrays;
import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @描述：应用类型常量枚举
 * @作者：songx
 * @创建时间：2016年12月1日,上午11:07:21 @版本：1.0
 */
public enum AppTypeEnum {
    
    /**
     * 应用分类
     */
    MASTER("MASTER", "主应用"),
    RECOMMEND("RECOMMEND", "推荐应用"),
    CHARGE("CHARGE", "付费应用"),
    
    ARTICLE("ARTICLE", "文章"),
    KK("KK", " 看一看"),
    LIVE("LIVE", "直播"),
    VOTE("VOTE", "投票"),
    ENROLL("ENROLL", "编创赛报名"),
    BM("BM", "报名"),
    NAIRE("NAIRE", "问卷调查"),
    BOOKCARD("BOOKCARD", "读书卡片"),
    TUTOR("TUTOR", "一对一辅导"),
    
    /**
     * 该类型应用已删除
     */
    DA("DA", "数据采集"),
    
    /**
     * add by gaop at 2017-6-13 16:52:07
     */
    GROUP("GROUP", "与你同行（圈子）"),
    ITEM_BANK("ITEM_BANK", "题库"),
    VOICE_MSG("VOICE_MSG", "语音留言"),
    AUDIO("AUDIO", "音频"),
    VIDEO("VIDEO", "视频"),
    IMAGE("IMAGE", "图片"),
    PDF("PDF", "PDF"),
    BOOK("BOOK", "图书"),
    EF("EF", "教育表格"),
    QA("QA", "问答"),
    LISTEN("LISTEN", "听力"),
    ANSWER("ANSWER", "答案"),
    ACTIVITY("ACTIVITY", "分享互动"),
    ZSCORE("ZSCORE", "标准分"),
    RECITE_WORD("RECITE_WORD", "背单词"),
    INTERACT("INTERACT", "互动墙"),
    SPECIAL("SPECIAL", "专题"),
    CLOCK("CLOCK", "打卡"),
    TEST("TEST", "趣味测试（测试工具）"),
    EBOOK("EBOOK", "电子书"),
    LIVE_TIMETABLE("LIVE_TIMETABLE", "直播课表"),
    DRAW("DRAW", "抽奖"),
    WISH("WISH", "愿望单"),
    LIVEAPP("LIVEAPP", "直播3.0"),
    TASTETEST("TASTETEST", "趣味测试"),
    VIDEO_CLASSIC("VIDEO_CLASSIC", "经典版视频"),
    AUDIO_MAGIC("AUDIO_MAGIC", "音频伴读魔法箱"),
    TEACH_RESOURCE("TEACH_RESOURCE", "教辅资料包"),
    COURSE_WARE("COURSE_WARE", "课件"),
    TEST_PAPER("TEST_PAPER", "试卷"),
    MATCH_LISTEN("MATCH_LISTEN", "配套听力"),
    WORD_DICTATION("WORD_DICTATION", "生词听写"),
    STROKE_ORDER("STROKE_ORDER", "笔顺动图"),
    ARTICLE_READING("ARTICLE_READING", "课文诵读"),
    ENGLISH_WALKMAN("ENGLISH_WALKMAN", "英语随身听"),
    WECHAT_STUDY_GROUP("WECHAT_STUDY_GROUP", "微信学习交流圈"),
    TASK_CLOCK("TASK_CLOCK", "任务打卡"),
    REWARD_CLOCK("REWARD_CLOCK", "奖励打卡"),
    CUSTOM_CLOCK("CUSTOM_CLOCK", "自定义打卡"),
    MEMBER("MEMBER", "开通会员"),
    ORAL_EVALUATION("ORAL_EVALUATION", "口语评测"),
    PBSTORY("PBSTORY", "绘本故事"),
    
    /**
     * add by songx at 2019-5-25 16:52:07
     */
    SUBJECTNOTE("SUBJECTNOTE", "错题本"),

    BOOK_CLICK("BOOK_CLICK", "点读书"),
    FLAG("FLAG", "立Flag");
    
    /**
     * 枚举转换
     */
    public static final Map<String, AppTypeEnum> APP_TYPE_MAP = Maps.newHashMap();
    
    static {
        Arrays.asList(AppTypeEnum.values()).forEach(m -> {
            APP_TYPE_MAP.put(m.value, m);
        });
    }
    
    /**
     * 值
     */
    public final String value;
    
    /**
     * 名称
     */
    public final String name;
    
    /**
     * 构造
     *
     * @param value
     */
    private AppTypeEnum(String value, String name) {
        this.value = value;
        this.name = name;
    }
    
    public static void main(String[] args) {
        System.out.println(AppTypeEnum.valueOf("SUBJECTNOTE"));
    }
    
}
