package com.pcloud.common.utils;

import com.pcloud.common.utils.string.StringUtil;

import java.util.Date;

/**
 * 作品和应用客户端连接拼装
 *
 * @author PENG
 */
public class ServeLinkUtils {

    private static String getAppUrl(String typeCode, String id, String basePath, String commonQuerys, String sceneCode) {
        String middlePath = "";
        if ("KK".equals(typeCode)) {
            return "*kk" + basePath + "A" + id + "/questionnaire" + commonQuerys;
        } else if ("LIVE".equals(typeCode) || "LIVE_TIMETABLE".equals(typeCode) || "SCHEDULE".equals(typeCode)) {
            return "*live" + basePath + "A" + id + "/liveinfo" + commonQuerys;
        } else if ("ACTIVITY".equals(typeCode)) {
            return basePath + "application/" + id + "/propaganda" + commonQuerys;
        } else if ("NAIRE".equals(typeCode) || "DA".equals(typeCode)) {
            return "*qn" + basePath + "A" + id + "/list" + commonQuerys;
        } else if ("SPECIAL".equals(typeCode)) {
            return "*st" + basePath + "A" + id + "/special" + commonQuerys;
        } else if ("VOTE".equals(typeCode)) {
            return "*vt" + basePath + "A" + id + "/list" + commonQuerys;
        } else if ("BM".equals(typeCode)) {
            return "*mt" + basePath + "A" + id+ "/summary" + commonQuerys;
        } else if ("RECITE_WORD".equals(typeCode)) {
            switch (sceneCode) {
                //消消乐
                case "LINK":
                    middlePath = "blocks";
                    break;
                default:
                    middlePath = "list";
            }
            return "*wd" + basePath + "A"+ id + "/" + middlePath + commonQuerys;
        } else if ("EF".equals(typeCode)) {
            return "*tb" + basePath + "A" + id + "/list" + commonQuerys;
        } else if ("TUTOR".equals(typeCode)) {
            return "*cc" + basePath + "A" + id + "/list" + commonQuerys;
        } else if ("ITEM_BANK".equals(typeCode)) {
            return "*pretest" + basePath + "A" + id + "/list" + commonQuerys;
        } else if ("GROUP".equals(typeCode)) {
            return "*group" + basePath + "A" + id + "/info" + commonQuerys;
        } else if ("ZSCORE".equals(typeCode)) {
            return "*zscore" + basePath + "A" + id + "/search" + commonQuerys;
        } else if ("VOICE_MSG".equals(typeCode)) {
            return "" + basePath + "application/" + id + "/voicemail" + commonQuerys;
        } else if ("BOOKCARD".equals(typeCode)) {
            return "*card" + basePath + "A" + id + "/home" + commonQuerys;
        } else if ("INTERACT".equals(typeCode)) {
            return "*interact" + basePath + "A" + id + "/home" + commonQuerys;
        } else if ("CLOCK".equals(typeCode)) {
            return "*clock" + basePath + "A" + id + "/custom/sign" + commonQuerys;
        } else if ("AUDIO_MAGIC".equals(typeCode)) {
            return "*magic" + basePath + "A" + id + "/box" + commonQuerys;
        } else if ("COURSE_WARE".equals(typeCode)) {
            return "*cw" + basePath + "A" + id + "/list" + commonQuerys;
        } else if ("WORD_DICTATION".equals(typeCode)) {
            return "*dictation" + basePath + "A" + id + "/list" + commonQuerys;
        } else if ("MATCH_LISTEN".equals(typeCode)) {
            return "*mv" + basePath + "A" + id + "/listen" + commonQuerys;
        } else if ("ARTICLE_READING".equals(typeCode)) {
            return "*ar" + basePath + "A" + id + "/reading" + commonQuerys;
        } else if ("ENGLISH_WALKMAN".equals(typeCode)) {
            return "*wm" + basePath + "A" + id + "/player" + commonQuerys;
        } else if ("PBSTORY".equals(typeCode)) {
            return "*pbstory" + basePath + "A" + id + "/list" + commonQuerys;
        } else if ("ORAL_EVALUATION".equals(typeCode)) {
            return "*speak" + basePath + "A" + id + "/info" + commonQuerys;
        } else if ("TEST".equals(typeCode)) {
            switch (sceneCode) {
                //属性测试
                case "TEST_CHARACTER":
                    middlePath = "char";
                    break;
                //知识测试
                case "TEST_KNOWLEDGE":
                    middlePath = "know";
                    break;
                //情感测试
                case "TEST_EMOTION":
                    middlePath = "emotion";
                    break;
                default:
                    middlePath = "char";
            }
            return "*tt" + basePath + "A" + id + "/" + middlePath + "/info" + commonQuerys;
        } else if ("WISH".equals(typeCode)) {
            return "*wish" + basePath + "A" + id + "/home" + commonQuerys;
        } else if ("DRAW".equals(typeCode)) {
            return "*luck" + basePath + "A" + id + "/luckPage" + commonQuerys;
        } else if ("VIDEO".equals(typeCode)) {
            return "" + basePath + "application/" + id + "/video" + commonQuerys;
        } else if ("EBOOK".equals(typeCode)) {
            return "" + basePath + "application/" + id + "/ebook" + commonQuerys;
        } else if ("AUDIO".equals(typeCode)) {
            switch (sceneCode) {
                // 绘本配乐
                case "PAINTING":
                    return "" + basePath + "application/" + id + "/audio/painting" + commonQuerys;
                // 绘本配乐
                case "LISTEN":
                    return "" + basePath + "application/" + id + "/audio/listen" + commonQuerys;
                // 绘本配乐
                case "LESSON":
                    return "" + basePath + "application/" + id + "/audio/lesson" + commonQuerys;
                default:
                    return "" + basePath + "application/" + id + "/audio" + commonQuerys + "&appType=" + typeCode;
            }
        } else if ("TEACH_RESOURCE".equals(typeCode)) {
            return "*tr" + basePath + "A" + id + "/packagelist" + commonQuerys;
        } else if ("TEST_PAPER".equals(typeCode)) {
            return "" + basePath + "application/" + id + "/testpaper/paperList/" + commonQuerys;
        } else if ("STROKE_ORDER".equals(typeCode)) {
            return "*pen" + basePath + "A" + id + "/list" + commonQuerys;
        } else if ("MEMBER".equals(typeCode)) {
            return "*member" + basePath + "A" + id + "/info" + commonQuerys;
        } else if ("SUBJECTNOTE".equals(typeCode)) {
            return "*subject" + basePath + "A" + id + commonQuerys;
        } else if ("BOOK_CLICK".equals(typeCode)) {
            return "*clickread" + basePath + "A" + id + commonQuerys;
        } else if ("FLAG".equals(typeCode)) {
            return "*flag" + basePath + "A" + id + "/entryFlag/start" + commonQuerys;
        } else {
            return "" + basePath + "application/" + id + "/display" + commonQuerys + "&appType=" + typeCode;
        }
    }

    private static String getProductUrl(String typeCode, String id, String basePath, String commonQuerys) {
        if ("PRETEST".equals(typeCode)) {
            return "*pretest" + basePath + "P" + id + "/list" + commonQuerys;
        } else if ("LIVE".equals(typeCode) || "LIVE_TIMETABLE".equals(typeCode) || "SCHEDULE".equals(typeCode)) {
            return "*live" + basePath + "A" + id + "/liveinfo" + commonQuerys + "&proType=SCHEDULE";
        } else if ("QA".equals(typeCode)) {
            return basePath + "application/-1/foranswer/select/" + id + commonQuerys;
        } else if ("SUBJECTNOTE".equals(typeCode)) {
            return "*subject" + basePath + "P" + id + commonQuerys;
        } else if ("ATTENDANCE_TASK".equals(typeCode)) {
            return "*clock" + basePath + "P" + id + commonQuerys;
        } else if ("VIDEO_SCHEDULE".equals(typeCode)) {
            return basePath + "product/display/" + id + "/video/preview" + commonQuerys;
        } else {
            return basePath + "product/display/" + id + commonQuerys;
        }
    }

    /**
     * 获取作品/应用跳转链接（不包含域名）
     * @param fromType PRODUCT或APP
     * @param typeCode 作品或应用类型
     * @param id 作品或应用ID
     * @param sceneCode 场景编码
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @param sourceType 来源
     * @return
     */
    public static String getServeLink(String fromType, String typeCode, String id, String sceneCode, String channelId, String adviserId, String sourceType) {
        String commonQuerys = "?source_type=WECHAT_GROUP";
        if (!StringUtil.isEmpty(sourceType)) {
            commonQuerys = "?source_type=" + sourceType;
        }
        if ("APP".equals(fromType)) {
            commonQuerys += "&isPreview=1&adviserId=" + adviserId;
        } else if ("PRODUCT".equals(fromType) && "QA".equals(typeCode)) {
            commonQuerys += "&proType=" + typeCode;
        }
        String basePath = "/C" + channelId + "/";
        String linkUrl = "";
        if ("PRODUCT".equals(fromType)) {
            if ("QA".equals(typeCode)) {
                linkUrl = basePath + "application/-1/foranswer/select/" + id + commonQuerys;
            } else {
                linkUrl = getProductUrl(typeCode, id, basePath, commonQuerys);
            }
        } else if ("APP".equals(fromType)) {
            sceneCode = null == sceneCode ? "" : sceneCode;
            linkUrl = getAppUrl(typeCode, id, basePath, commonQuerys, sceneCode);
        }
        return linkUrl;
    }

    /**
     * 获取作品/应用跳转链接（包含域名）
     * @param fromType PRODUCT或APP
     * @param typeCode 作品或应用类型
     * @param id 作品或应用ID
     * @param sceneCode 场景编码
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @param sourceType 来源
     * @param officialAccountsId 公众号ID
     * @param protocol 公众号协议 https://或http://
     * @param domain 域名
     * @param firstDomain 小应用域名
     * @param random 公众号表的随机数
     * @return
     */
    public static String getCompleteLink(String fromType, String typeCode, String id, String sceneCode, String channelId,
                                          String adviserId, String sourceType, String officialAccountsId, String protocol, String domain,
                                          String firstDomain, String random) {
        String serveLink = getServeLink(fromType, typeCode, id, sceneCode, channelId, adviserId, sourceType);
        return getCompleteLink(serveLink, officialAccountsId, protocol, domain, firstDomain, random);
    }

    /**
     * 获取作品/应用跳转链接（包含域名）
     * @param serveLink 后缀链接
     * @param officialAccountsId 公众号ID
     * @param protocol 公众号协议 https://或http://
     * @param domain 域名
     * @param firstDomain 小应用域名
     * @param random 公众号表的随机数
     * @return
     */
    public static String getCompleteLink(String serveLink, String officialAccountsId, String protocol, String domain,
                                          String firstDomain, String random) {
        if (StringUtil.isEmpty(protocol)) {
            protocol = "http://";
        }
        String resultUrl = "";
        if (!StringUtil.isEmpty(serveLink)) {
            if (serveLink.startsWith("*")) {
                String endUrl = serveLink.substring(serveLink.indexOf("/"), serveLink.length());
                if (random == null) {
                    resultUrl = protocol + "app." + firstDomain + "/" + serveLink.substring(1, serveLink.indexOf("/")) + "/W"
                            + officialAccountsId + endUrl;
                } else {
                    resultUrl = protocol + "app" + random + "." + firstDomain + "/" + serveLink.substring(1, serveLink.indexOf("/")) + "/W"
                            + officialAccountsId + endUrl;
                }
            } else {
                resultUrl = protocol + domain + "/W" + officialAccountsId + serveLink;
            }
        }
        return resultUrl;
    }
}
