package com.pcloud.common.utils.aliyun.test;


import com.obs.services.model.ObjectMetadata;

import com.pcloud.common.dto.OssMediaInfoDTO;
import com.pcloud.common.entity.UploadResultInfo;
import com.pcloud.common.exceptions.FileException;
import com.pcloud.common.utils.aliyun.OssUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName com.pcloud.auditcenter.hw.utils.test.ObsTest
 * @Author 吴博
 * @Description 华为云测试类
 * @Date 2020/5/24 9:27
 * @Version 1.0
 **/
@RestController
@RequestMapping("obsTest")
@Slf4j
public class ObsTest {

    private static final String textFilePath = "C:\\Users\\Administrator\\Desktop\\sql.txt";

    private static final String  audioFilePath = "C:\\Users\\Administrator\\Desktop\\123321.mp3";

    private static final String  imageFilePath = "C:\\Users\\Administrator\\Desktop\\girl.jpg";

    private static final String  imageFileUrl = "https://oss.raysgo.com/oss/upload/image/jpg/add52c60c88a4989bdf6bdb554b5f928.jpg";



    private static final String videoFilePath = "C:\\Users\\Administrator\\Desktop\\e610844f3210d9e249fc8ee0cc6b9a1b_20190815173921219.mp4";

    private static final String parentFileUrl = "https://oss.raysgo.com/oss/upload/video/mp4/b2f2df50279d43b4af52ebb760924e08";

    private static final String videoUrl = "https://oss.raysgo.com/oss/upload/video/mp4/e297ea15516146acabbbcb8c31fe0f92.mp4";

    private static final String ObjectKey = "oss/upload/video/mp4/b2f2df50279d43b4af52ebb760924e08.mp4";

    private static final String textUrl = "https://oss.raysgo.com/oss/upload/text/txt/4b19722b10604da282497b80c77860fe.txt";

    private static final String outFilePath4Mp3 = "C:\\Users\\Administrator\\Desktop\\localaudio.mp3";

    private static final String outFilePath4Mp4 = "C:\\Users\\Administrator\\Desktop\\localVideo.mp4";


    private static final String huaweiImage = "C:\\Users\\Administrator\\Desktop\\1588081459(1).png";

    private static final String huaweiImageUrl = "https://oss.raysgo.com/oss/upload/image/png/7348e76b4a654fdbbccf3a2adbe0d028.png";



    @RequestMapping(value = "uploadFileByte", method = RequestMethod.GET)
    public UploadResultInfo uploadFileByte() throws FileException {
        String content = "Hello OBS";
        byte[] buff = content.getBytes();
        String fileName = "";
        String fileType = "txt";
        UploadResultInfo uploadResultInfo = OssUtils.uploadFileByte(buff, fileName, fileType);
        log.info(uploadResultInfo.toString());
        return  uploadResultInfo;
    }

    @RequestMapping(value = "uploadLocalFile", method = RequestMethod.GET)
    public UploadResultInfo uploadLocalFile() throws FileException {
        String content = "Hello OBS";
        byte[] buff = content.getBytes();
        String fileName = "";
        String fileType = "txt";
        UploadResultInfo uploadResultInfo = OssUtils.uploadLocalFile(videoFilePath,null);
        log.info(uploadResultInfo.toString());
        return uploadResultInfo;
    }

    @RequestMapping(value = "uploadLocalFile4Child", method = RequestMethod.GET)
    public UploadResultInfo uploadLocalFile4Child() throws FileException {
        String content = "Hello OBS";
        byte[] buff = content.getBytes();
        String fileName = "";
        String fileType = "txt";
        UploadResultInfo uploadResultInfo = OssUtils.uploadLocalFile4Child(audioFilePath,parentFileUrl);
        log.info(uploadResultInfo.toString());
        return uploadResultInfo;
    }


    @RequestMapping(value = "getMediaInfo", method = RequestMethod.GET)
    public OssMediaInfoDTO getMediaInfo() throws FileException {
        String content = "Hello OBS";
        byte[] buff = content.getBytes();
        String fileName = "";
        String fileType = "txt";
        OssMediaInfoDTO ossMediaInfoDTO = OssUtils.getMediaInfo(videoUrl);
        log.info(ossMediaInfoDTO.toString());
        return ossMediaInfoDTO;
    }



    @RequestMapping(value = "getObjectMetadata", method = RequestMethod.GET)
    public ObjectMetadata getObjectMetadata() throws FileException {
        String content = "Hello OBS";
        byte[] buff = content.getBytes();
        String fileName = "";
        String fileType = "txt";
        ObjectMetadata objectMetadata = OssUtils.getObjectMetadata(ObjectKey,"whlg-oss-test-002");
        log.info(objectMetadata.toString());
        return objectMetadata;
    }

    @RequestMapping(value = "downloadFile2Byte", method = RequestMethod.GET)
    public String downloadFile2Byte() throws FileException {
        String content = "Hello OBS";
        byte[] buff = content.getBytes();
        String fileName = "";
        String fileType = "txt";
        byte[] bytes = OssUtils.downloadFile2Byte(textUrl);
        log.info(new String (bytes));
        return new String (bytes);
    }


    @RequestMapping(value = "downloadFile", method = RequestMethod.GET)
    public void downloadFile() throws FileException {
        String content = "Hello OBS";
        byte[] buff = content.getBytes();
        String fileName = "";
        String fileType = "txt";
        OssUtils.downloadFile(videoUrl,outFilePath4Mp4);
    }


    @RequestMapping(value = "imageWidthResize", method = RequestMethod.GET)
    public void imageWidthResize() throws FileException {
        String content = "Hello OBS";
        byte[] buff = content.getBytes();
        String fileName = "";
        String fileType = "txt";
        OssUtils.imageWidthResize(imageFileUrl,100);
    }
    @RequestMapping(value = "imageResize", method = RequestMethod.GET)
    public void imageResize() throws FileException {
        String content = "Hello OBS";
        byte[] buff = content.getBytes();
        String fileName = "";
        String fileType = "txt";
        OssUtils.imageResize(imageFileUrl,50);
    }

    @RequestMapping(value = "imageAutoOrient", method = RequestMethod.GET)
    public void imageAutoOrient() throws FileException {
        String content = "Hello OBS";
        byte[] buff = content.getBytes();
        String fileName = "";
        String fileType = "txt";
        OssUtils.imageAutoOrient(imageFileUrl,50);
    }

    @RequestMapping(value = "imageCrop", method = RequestMethod.GET)
    public void imageCrop() throws FileException {
        String content = "Hello OBS";
        byte[] buff = content.getBytes();
        String fileName = "";
        String fileType = "txt";
        OssUtils.imageCrop(imageFileUrl,500,500,0,0);
    }

    @RequestMapping(value = "imageCropSaveas", method = RequestMethod.GET)
    public void imageCropSaveas() throws FileException {
        OssUtils.imageCropSaveas(imageFileUrl,500,500,0,0);
    }

    @RequestMapping(value = "imageWatermark", method = RequestMethod.GET)
    public void imageWatermark() throws FileException {
        String waterMark = OssUtils.imageWatermark(imageFileUrl,"哈哈哈哈，大笨蛋");
        log.info(waterMark);

    }

    @RequestMapping(value = "imageWatermark4Image", method = RequestMethod.GET)
    public void  imageWatermark4Image() throws FileException {
        String waterMark = OssUtils. imageWatermark4Image(imageFileUrl,huaweiImageUrl);
        log.info(waterMark);

    }

}