package com.pcloud.book.group.service;

import com.pcloud.book.group.dto.GroupClassifyQrcodeDTO;
import com.pcloud.book.group.dto.GroupQrcodeBaseDTO;
import com.pcloud.book.group.dto.GroupQrcodeInfo4Advertising;
import com.pcloud.book.group.dto.ProAssocGroupAndUserNumberDTO;
import com.pcloud.common.dto.ResponseDto;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author lily
 * @date 2019/4/28 20:20
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookGroupClassifyCloud", path = "book/v1.0/bookGroupClassifyService")
@Api(description = "微信群分类接口")
public interface BookGroupClassifyService {

    @ApiOperation("根据微信群标识获取相关id")
    @GetMapping("getClassifyQrcodeInfo")
    ResponseEntity<ResponseDto<GroupClassifyQrcodeDTO>> getClassifyQrcodeInfo(@RequestParam("weixinGroupId") String weixinGroupId);

    @ApiOperation("根据微信群标识获取相关id")
    @PostMapping("listGroupQrcodeBaseInfo")
    ResponseEntity<ResponseDto<Map<String, GroupQrcodeBaseDTO>>> listGroupQrcodeBaseInfo(@RequestBody List<String> weixinGroupIds);

    @ApiOperation("获取商品关联群数量与人数")
    @GetMapping("getProAssocGroupAndUserNumber")
    ResponseEntity<ResponseDto<ProAssocGroupAndUserNumberDTO>> getProAssocGroupAndUserNumber(@RequestParam("productId") Long productId);

    @ApiOperation("根据微信群标识获取相关广告信息")
    @PostMapping("listGroupQrcodeInfo4Advertising")
    ResponseEntity<ResponseDto<Map<String, GroupQrcodeInfo4Advertising>>> listGroupQrcodeInfo4Advertising(@RequestBody List<String> wxGroupIds);

    @ApiOperation("根据条件查询微信群列表")
    @GetMapping("listQrcodeIdsByLabelQuery")
    public ResponseEntity<ResponseDto<List<Long>>> listQrcodeIdsByLabelQuery(
            @RequestParam(value = "query", required = false) String query,
            @RequestParam(value = "proLabelId", required = false) Long proLabelId,
            @RequestParam(value = "depLabelId", required = false) Long depLabelId,
            @RequestParam(value = "purLabelId", required = false) Long purLabelId);

    @ApiOperation("过滤被删除的群分类、群二维码")
    @PostMapping("filterDeleteId")
    ResponseEntity<ResponseDto<List<Long>>> filterDeleteId(@RequestBody List<String >wxGroupIdList);

    @ApiOperation("获取用户支付金额")
    @GetMapping("getPayPrice")
    ResponseEntity<ResponseDto<BigDecimal>> getPayPrice(@RequestParam("qrcodeId") Long qrcodeId, @RequestParam("wxUserId") String wxUserId);
}
