package com.pcloud.book.adnews.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author zhengyongqiang
 * @date 2019/8/14 10:43
 */
@Data
public class AdNewsMessageStatisticVO {

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("微信群名称")
    private String groupName;

    @ApiModelProperty("分类")
    private String classify;

    @ApiModelProperty("社群码名称")
    private String groupQrcodeName;

    @ApiModelProperty("社群书名称")
    private String bookName;

    @ApiModelProperty("专业")
    private String depLabelName;

    @ApiModelProperty("深度")
    private String proLabelName;

    @ApiModelProperty("目的")
    private String purLabelName;

    @ApiModelProperty("专业Id")
    private Long depLabelId;

    @ApiModelProperty("深度Id")
    private Long proLabelId;

    @ApiModelProperty("目的Id")
    private Long purLabelId;

    @ApiModelProperty("内容来源")
    private Integer contentFrom;

    @ApiModelProperty("发送消息数")
    private Integer messageCount;

    @ApiModelProperty("发送时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("点击次数")
    private Long clickCount;

    @ApiModelProperty("点击人数")
    private Long userCount;
}
