package com.pcloud.book.advertising.service.impl;

import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.pcloud.book.advertising.biz.AdvertisingSpaceBiz;
import com.pcloud.book.advertising.service.AdvertisingSpaceService;
import com.pcloud.common.exceptions.BizException;

import java.util.Map;

/**
 * Description 广告位内部接口实现类
 * Created by PENG on 2019/5/6.
 */
@RestController("advertisingSpaceService")
@RequestMapping("advertisingSpaceService")
public class AdvertisingSpaceServiceImpl implements AdvertisingSpaceService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertisingSpaceServiceImpl.class);

    @Autowired
    private AdvertisingSpaceBiz advertisingSpaceBiz;

    /**
     * 每日凌晨计算昨日广告位收益
     */
    @Override
    @RequestMapping(value = "calculateAdvertisingIncomeYesterday", method = RequestMethod.GET)
    public void calculateAdvertisingIncomeYesterday() throws BizException {
        advertisingSpaceBiz.calculateAdvertisingIncomeYesterday();
    }

    @ApiOperation("发送广告计划")
    @PostMapping("sendAdvertisingPlan")
    @Override
    public void sendAdvertisingPlan(@RequestBody Map<String, Object> map) throws BizException {
        LOGGER.info("内部接口群发广告被调用"+map.toString());
        advertisingSpaceBiz.sendAdvertisingPlan(new Long(map.get("advertisingPutId").toString()));
    }
}
