/**
 * 
 */
package com.pcloud.book.book.facade.impl;

import com.pcloud.book.base.dto.CountDto;
import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.book.book.dto.AdviserManageDto;
import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.book.book.dto.BookCountDto;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.book.book.facade.BookAdviserFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @描述：顾问书籍管理接口实现类
 * @作者：songx
 * @创建时间：2016年12月30日,下午6:03:13 @版本：1.0
 */
@RequestMapping("/bookAdviser")
@RestController("bookAdviserFacade")
public class BookAdviserFacadeImpl implements BookAdviserFacade {

	@Autowired
	private BookAdviserBiz bookAdviserBiz;

	/**
	 * 创建顾问和书籍的联系
	 */
	@Override
	@RequestMapping(value = "create", method = RequestMethod.POST)
	public ResponseDto<BookAdviserDto> create(@RequestHeader("token") String token,
			@RequestBody BookAdviser bookAdviser) throws BizException, PermissionException, JsonParseException {
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookAdviser.setAdviserId(adviserId);
		bookAdviserBiz.create(bookAdviser);

		BookAdviserDto bookAdviserDto = new BookAdviserDto();
		bookAdviserDto.setBookAdviserId(bookAdviser.getBookAdviserId());
		return new ResponseDto<>(bookAdviserDto);
	}

	/**
	 * 编辑管理--获取编辑列表（平台端）
	 */
	@Override
	@RequestMapping(value = "listAdviser", method = RequestMethod.GET)
	public ResponseDto<?> getAdviserList(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId)
			throws BizException, PermissionException, JsonParseException {
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		List<AdviserManageDto> adviserManageDtos = bookAdviserBiz.getAdviserList(bookId);
		return new ResponseDto<List<AdviserManageDto>>(
				adviserManageDtos == null ? new ArrayList<>() : adviserManageDtos);
	}

	/**
	 * 编辑管理--删除副编辑
	 */
	@Override
	@RequestMapping(value = "batDelViceAdviser", method = RequestMethod.POST)
	public ResponseDto<?> delViceAdviser(@RequestHeader("token") String token,
			@RequestBody List<BookAdviser> bookAdvisers) throws BizException, PermissionException, JsonParseException {
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookAdviserBiz.delViceAdviser(bookAdvisers);
		return new ResponseDto<>();
	}

	/**
	 * 编辑 - 是否有默认Ray纸书
	 */
	@Override
	@RequestMapping(value = "getDefaultBook", method = RequestMethod.GET)
	public ResponseDto<?> getDefaultBook(@RequestHeader("token") String token,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		BookAdviserDto bookAdviserDto = bookAdviserBiz.getDefaultBook(channelId, adviserId);
		return new ResponseDto<>(bookAdviserDto == null ? new BookAdviserDto() : bookAdviserDto);
	}

	/**
	 * 出版社下编辑的所有书刊的数目
	 * 
	 * @param token
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@Override
	@RequestMapping(value = "getBookCount", method = RequestMethod.GET)
	public ResponseDto<CountDto> getBookCount(@RequestHeader("token") String token)
			throws BizException, PermissionException, JsonParseException {
		Long agentId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		Integer bookCount = bookAdviserBiz.getBookCount(agentId);
		CountDto count = new CountDto();
		count.setCount(bookCount);
		return new ResponseDto<>(count);
	}

	/**
	 * 每日新增书刊数-出版
	 */
	@Override
	@RequestMapping(value = "listBookCountByDate4Agent", method = RequestMethod.GET)
	public ResponseDto<List<BookCountDto>> listBookCountByDate4Agent(@RequestHeader("token") String token)
			throws BizException, PermissionException, JsonParseException {
		Long agentId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		List<BookCountDto> booksCount = bookAdviserBiz.listBookCountByDate4Agent(agentId);
		return new ResponseDto<>(booksCount == null ? new ArrayList<>() : booksCount);
	}

	/**
	 * 删除书籍（编辑端）
	 */
	@Override
	@RequestMapping(value = "deleteBook4Adviser", method = RequestMethod.GET)
	public ResponseDto<?> deleteBook4Adviser(@RequestHeader("token") String token,
			@RequestParam("bookId") Long bookId,
			@RequestParam("channelId") Long channelId)
			throws BizException, PermissionException, JsonParseException {
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookAdviserBiz.deleteBook4Adviser(bookId, adviserId, channelId);
		return new ResponseDto<>();
	}

	/**
	 * 恢复书籍-编辑
	 */
	@Override
	@RequestMapping(value = "recoverBook4Adviser", method = RequestMethod.GET)
	public ResponseDto<?> recoverBook4Adviser(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookAdviserBiz.recoverBook4Adviser(bookId, adviserId, channelId, null,null, true);
		return new ResponseDto<>();
	}
	
	/**
	 * 获取编辑的图书总数
	 */
	@Override
	@RequestMapping(value = "getAdviserBookCount", method = RequestMethod.GET)
	public ResponseDto<CountDto> getAdviserBookCount(@RequestHeader("token") String token)
			throws PermissionException, JsonParseException, BizException {
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		CountDto countDto = bookAdviserBiz.getAdviserBookCount(adviserId);
		return new ResponseDto<>(countDto);
	}
}
