package com.pcloud.book.copyright.facade.impl;

import com.pcloud.book.copyright.biz.BookAuthInfoBiz;
import com.pcloud.book.copyright.facade.BookAuthInfoFacade;
import com.pcloud.book.copyright.vo.BookAuthInfoAndServesVO;
import com.pcloud.book.copyright.vo.BookAuthInfoVO;
import com.pcloud.book.copyright.vo.BookAuthInfoWechatVO;
import com.pcloud.book.copyright.vo.GetAuthInfoParam;
import com.pcloud.book.copyright.vo.ListHaveAuthBookParam;
import com.pcloud.book.copyright.vo.SetAuthStatusParam;
import com.pcloud.book.copyright.vo.SetAuthOpenParam;
import com.pcloud.book.copyright.vo.SetLocationDescVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author lily
 * @date 2018/12/3 10:58
 */
@RequestMapping("bookAuthInfo")
@RestController("bookAuthInfoFacade")
public class BookAuthInfoFacadeImpl implements BookAuthInfoFacade {

    @Autowired
    private BookAuthInfoBiz bookAuthInfoBiz;

    @Override
    @PostMapping("setBookAuthOpen")
    public ResponseDto<?> setBookAuthOpen(@RequestHeader("token") String token, @RequestBody SetAuthOpenParam setAuthOpenParam) throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookAuthInfoBiz.setBookAuthOpen(setAuthOpenParam, adviserId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("setAuthStatus")
    public ResponseDto<?> setAuthStatus(@RequestHeader("token") String token, @RequestBody SetAuthStatusParam setAuthStatusParam) throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookAuthInfoBiz.setAuthStatus(setAuthStatusParam, adviserId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("setBookLocationDesc")
    public ResponseDto<?> setBookLocationDesc(@RequestHeader("token") String token, @RequestBody SetLocationDescVO setLocationDesc) throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookAuthInfoBiz.setBookLocationDesc(setLocationDesc, adviserId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getIsHaveAuthBook")
    public ResponseDto<Boolean> getIsHaveAuthBook(@RequestHeader("token") String token) throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        Boolean isHaveBook = bookAuthInfoBiz.getIsHaveAuthBook(adviserId);
        return new ResponseDto<>(isHaveBook);
    }

    @Override
    @GetMapping("getInfoByBook")
    public ResponseDto<BookAuthInfoVO> getInfoByBook(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId) throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        BookAuthInfoVO bookAuthInfoVO = bookAuthInfoBiz.getInfoByBook(bookId, channelId, adviserId);
        return new ResponseDto<>(bookAuthInfoVO);
    }

    @Override
    @PostMapping("getInfoByBook4Wechat")
    public ResponseDto<BookAuthInfoWechatVO> getInfoByBook4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody GetAuthInfoParam getAuthInfoParam) throws PermissionException, BizException {
        Long channelId = Cookie.getId(userInfo, Cookie._CHANNEL_ID);
        BookAuthInfoWechatVO bookAuthInfoVO = bookAuthInfoBiz.getInfoByBook4Wechat(getAuthInfoParam, channelId);
        return new ResponseDto<>(bookAuthInfoVO);
    }

    @Override
    @GetMapping("getInfoAndServesByBook")
    public ResponseDto<BookAuthInfoAndServesVO> getInfoAndServesByBook(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId) throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        BookAuthInfoAndServesVO bookAuthInfoAndServesVO = bookAuthInfoBiz.getInfoAndServesByBook(bookId, channelId, adviserId);
        return new ResponseDto<>(bookAuthInfoAndServesVO);
    }

    @Override
    @PostMapping("listHaveSetAuthBook")
    public ResponseDto<PageBeanNew> listHaveSetAuthBook(@RequestHeader("token") String token, @RequestBody ListHaveAuthBookParam listHaveAuthBookParam)
            throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        PageBeanNew pageBeanNew = bookAuthInfoBiz.listHaveSetAuthBook(listHaveAuthBookParam, adviserId) ;
        return new ResponseDto<>(pageBeanNew);
    }

    @Override
    @GetMapping("isHaveExport")
    public ResponseDto<Boolean> isHaveExport(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId)
            throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        Boolean isCanExport = bookAuthInfoBiz.isHaveExport(bookId, channelId, adviserId);
        return new ResponseDto<>(isCanExport == null ? false : isCanExport);
    }
}
