package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.AppClickRecordDao;
import com.pcloud.book.group.dto.AppClickDTO;
import com.pcloud.book.group.dto.AppStatisticsDTO;
import com.pcloud.book.group.entity.AppClickRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/29 17:43
 **/
@Component("appClickRecordDao")
public class AppClickRecordDaoImpl extends BaseDaoImpl<AppClickRecord> implements AppClickRecordDao {
    @Override
    public List<AppStatisticsDTO> getClickStatisticsByServeIds(List<Long> serveIds, Long qrcodeId, Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("qrcodeId", qrcodeId);
        map.put("bookGroupId", bookGroupId);
        map.put("serveIds", serveIds);
        return this.getSqlSession().selectList(this.getStatement("getClickStatisticsByServeIds"), map);
    }

    @Override
    public List<AppClickDTO> getRecentlyClick(Long wechatUserId, Long qrcodeId, Integer top) {
        Map<String, Object> map = new HashMap<>();
        map.put("qrcodeId", qrcodeId);
        map.put("wechatUserId", wechatUserId);
        map.put("top", top);
        return this.getSqlSession().selectList(this.getStatement("getRecentlyClick"), map);
    }
}
