package com.pcloud.book.group.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.pcloud.book.group.dto.PersonalQrcodeDTO;
import org.springframework.stereotype.Repository;
import com.pcloud.book.group.dao.BookGroupDao;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.QrcodeNameAndProIdDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * Description 社群书群二维码数据访问层接口实现类
 * Created by PENG on 2019/4/17.
 */
@Repository("bookGroupDao")
public class BookGroupDaoImpl extends BaseDaoImpl<BookGroup> implements BookGroupDao {

    /**
     * 获取DTO信息
     */
    @Override
    public BookGroupDTO getDTOById(Long bookGroupId) {
        return super.getSqlSession().selectOne(getStatement("getDTOById"), bookGroupId);
    }

    /**
     * 批量获取DTO信息
     */
    @Override
    public List<BookGroupDTO> getDTOByIds(List<Long> bookGroupIds) {
        return super.getSqlSession().selectList(getStatement("getDTOByIds"), bookGroupIds);
    }

    /**
     * 获取DTO信息
     */
    @Override
    public BookGroupDTO getDTOByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return super.getSqlSession().selectOne(getStatement("getDTOByBookId"), paramMap);
    }

    /**
     * 根据书刊ID删除
     */
    @Override
    public long deleteByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return super.getSqlSession().update(getStatement("deleteByBookId"), paramMap);
    }

    /**
     * 根据书刊ID恢复
     */
    @Override
    public long recoverByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return super.getSqlSession().update(getStatement("recoverByBookId"), paramMap);
    }

    /**
     * 关联社群码和社群书
     */
    @Override
    public long linkBookGroup(BookGroup bookGroup) {
        return super.getSqlSession().update(getStatement("linkBookGroup"), bookGroup);
    }

    /**
     * 获取编辑社群书数量
     */
    @Override
    public Integer getBookGroupCount(Long adviserId) {
        return super.getSqlSession().selectOne(getStatement("getBookGroupCount"), adviserId);
    }

    @Override
    public QrcodeNameAndProIdDTO getQrcodeNameAndProId(Long bookGroupId) {
        return super.getSqlSession().selectOne(getStatement("getQrcodeNameAndProId"), bookGroupId);
    }

    @Override
    public Integer getRankType(Long bookGroupId) {
        return super.getSqlSession().selectOne(getStatement("getRankType"), bookGroupId);
    }

    @Override
    public void updateRankType(Long bookGroupId, Integer rankType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookGroupId", bookGroupId);
        paramMap.put("rankType", rankType);
        super.getSqlSession().update(getStatement("updateRankType"), paramMap);
    }

    @Override
    public String getSpareQr(Long bookGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getSpareQr"), bookGroupId);
    }

    @Override
    public List<BookGroupDTO> getBookBaseInfoByIds(List<Long> bookGroupIds) {
        return this.getSqlSession().selectList(this.getStatement("getBookBaseInfoByIds"), bookGroupIds);
    }

    @Override
    public BookGroupDTO getBaseInfoBySceneId(Long sceneId) {
        return this.getSqlSession().selectOne(this.getStatement("getBaseInfoBySceneId"), sceneId);
    }

    @Override
    public Boolean isSpecialAgent(Long agentId) {
        return this.getSqlSession().selectOne(this.getStatement("isSpecialAgent"), agentId);
    }

    @Override
    public void updatePersonQrcode(PersonalQrcodeDTO personalQrcodeDTO) {
        Map<String,Object> map = new HashMap<>();
        map.put("newQrcodeUrl",personalQrcodeDTO.getNewQrcodeUrl());
        map.put("oldQrcodeUrl",personalQrcodeDTO.getOldQrcodeUrl());
        this.getSqlSession().update(this.getStatement("updatePersonQrcode"), map);
    }

    @Override
    public List<BookGroupDTO> getBookInfoByIdsWithBookClockInfoId(Map<String,Object> paramMap) {
        return this.getSqlSession().selectList(this.getStatement("getBookInfoByIdsWithBookClockInfoId"), paramMap);
    }

    @Override
    public void updateIsShowBookName(Boolean isShowBookName, Long partyId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("isShowBookName", isShowBookName);
        paramMap.put("partyId", partyId);
        super.getSqlSession().update(getStatement("updateIsShowBookName"), paramMap);
    }

    @Override
    public Boolean getIsShowBookName(Long partyId) {
        return this.getSqlSession().selectOne(this.getStatement("getIsShowBookName"), partyId);
    }
}
