package com.pcloud.book.group.service.impl;

import com.pcloud.book.group.biz.BookGroupClassifyBiz;
import com.pcloud.book.group.biz.GroupQrcodeBiz;
import com.pcloud.book.group.dto.*;
import com.pcloud.book.group.service.BookGroupClassifyService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;

/**
 * @author lily
 * @date 2019/4/28 20:23
 */
@RestController("bookGroupClassifyService")
@RequestMapping("bookGroupClassifyService")
public class BookGroupClassifyServiceImpl implements BookGroupClassifyService {
    @Autowired
    private BookGroupClassifyBiz bookGroupClassifyBiz;
    @Autowired
    private GroupQrcodeBiz groupQrcodeBiz;

    @Override
    @GetMapping("getClassifyQrcodeInfo")
    public ResponseEntity<ResponseDto<GroupClassifyQrcodeDTO>> getClassifyQrcodeInfo(@RequestParam("weixinGroupId") String weixinGroupId) {
        GroupClassifyQrcodeDTO groupClassifyQrcodeDTO = bookGroupClassifyBiz.getClassifyQrcodeInfo(weixinGroupId);
        return ResponseHandleUtil.toResponse(groupClassifyQrcodeDTO);
    }

    @Override
    @PostMapping("listGroupQrcodeBaseInfo")
    public ResponseEntity<ResponseDto<Map<String, GroupQrcodeBaseDTO>>> listGroupQrcodeBaseInfo(@RequestBody List<String> weixinGroupIds) {
        Map<String, GroupQrcodeBaseDTO> groupQrcodeMap =  bookGroupClassifyBiz.listGroupQrcodeBaseInfo(weixinGroupIds);
        return ResponseHandleUtil.toResponse(groupQrcodeMap);
    }

    @Override
    @GetMapping("getProAssocGroupAndUserNumber")
    public ResponseEntity<ResponseDto<ProAssocGroupAndUserNumberDTO>> getProAssocGroupAndUserNumber(@RequestParam("productId") Long productId) {
        ProAssocGroupAndUserNumberDTO proAssocGroupAndUserNumberDTO = bookGroupClassifyBiz.getProAssocGroupAndUserNumber(productId);
        return ResponseHandleUtil.toResponse(proAssocGroupAndUserNumberDTO);
    }

    @Override
    @PostMapping("listGroupQrcodeInfo4Advertising")
    public ResponseEntity<ResponseDto<Map<String, GroupQrcodeInfo4Advertising>>> listGroupQrcodeInfo4Advertising(@RequestBody List<String> wxGroupIds) {
        Map<String, GroupQrcodeInfo4Advertising> map = groupQrcodeBiz.listGroupQrcodeInfo4Advertising(wxGroupIds);
        return ResponseHandleUtil.toResponse(map);
    }

    @Override
    @ApiImplicitParams({
            @ApiImplicitParam(name = "query", value = "书籍名称", dataType = "string",required = false, paramType = "query"),
            @ApiImplicitParam(name = "proLabelId", value = "专业标签id", dataType = "long",required = false, paramType = "query"),
            @ApiImplicitParam(name = "depLabelId", value = "深度标签id", dataType = "long",required = false, paramType = "query"),
            @ApiImplicitParam(name = "purLabelId", value = "目的标签id", dataType = "long",required = false, paramType = "query")
    })
    @GetMapping("listQrcodeIdsByLabelQuery")
    public ResponseEntity<ResponseDto<List<Long>>> listQrcodeIdsByLabelQuery(
            @RequestParam(value = "query", required = false) String query,
            @RequestParam(value = "proLabelId", required = false) Long proLabelId,
            @RequestParam(value = "depLabelId", required = false) Long depLabelId,
            @RequestParam(value = "purLabelId", required = false) Long purLabelId) {
        List<Long> list = groupQrcodeBiz.listQrcodeIdsByLabelQuery(query, proLabelId, depLabelId, purLabelId);
        return ResponseHandleUtil.toResponse(list);
    }

    @Override
    @PostMapping("filterDeleteId")
   public  ResponseEntity<ResponseDto<List<Long>>> filterDeleteId(@RequestBody List<String >wxGroupIdList){
        List<Long>qrcodeIds =  groupQrcodeBiz.filterDeleteId(wxGroupIdList);
        return ResponseHandleUtil.toResponse(qrcodeIds);
    }

    @Override
    @GetMapping("getPayPrice")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "qrcodeId", value = "qrcodeId", dataType = "long", required = true, paramType = "query"),
            @ApiImplicitParam(name = "wxUserId", value = "wxUserId", dataType = "string", required = true, paramType = "query")
    })
    public ResponseEntity<ResponseDto<BigDecimal>> getPayPrice(@RequestParam("qrcodeId") Long qrcodeId, @RequestParam("wxUserId") String wxUserId) {
        return ResponseHandleUtil.toResponse(bookGroupClassifyBiz.getPayPrice(qrcodeId, wxUserId));
    }
}
