package com.pcloud.book.riddle.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("猜谜记录")
public class RiddleRecord extends BaseEntity{

    @ApiModelProperty("谜语id")
    private Long riddleId;

    @ApiModelProperty("消息内容")
    private String messageContent;

    @ApiModelProperty("微信群")
    private String wxGroupId;

    @ApiModelProperty("微信用户")
    private String wxUserId;

    @ApiModelProperty("是否正确")
    private Boolean correct;

    @ApiModelProperty("进度状态")
    private Integer status;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("通关次数")
    private Integer finishCount;

    public Long getRiddleId() {
        return riddleId;
    }

    public void setRiddleId(Long riddleId) {
        this.riddleId = riddleId;
    }

    public String getMessageContent() {
        return messageContent;
    }

    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    public String getWxGroupId() {
        return wxGroupId;
    }

    public void setWxGroupId(String wxGroupId) {
        this.wxGroupId = wxGroupId == null ? null : wxGroupId.trim();
    }

    public String getWxUserId() {
        return wxUserId;
    }

    public void setWxUserId(String wxUserId) {
        this.wxUserId = wxUserId == null ? null : wxUserId.trim();
    }

    public Boolean getCorrect() {
        return correct;
    }

    public void setCorrect(Boolean correct) {
        this.correct = correct;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getFinishCount() {
        return finishCount;
    }

    public void setFinishCount(Integer finishCount) {
        this.finishCount = finishCount;
    }
}