package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingMasterDao;
import com.pcloud.book.advertising.dto.AdvertisingMasterDTO;
import com.pcloud.book.advertising.entity.AdvertisingMaster;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Description 广告主数据访问层接口实现类
 * Created by PENG on 2019/4/26.
 */
@Repository("advertisingMasterDao")
public class AdvertisingMasterDaoImpl extends BaseDaoImpl<AdvertisingMaster> implements AdvertisingMasterDao {

    /**
     * 获取所有广告主
     */
    @Override
    public List<AdvertisingMasterDTO> getAllMaster() {
        return super.getSqlSession().selectList(getStatement("getAllMaster"));
    }

    /**
     * 获取广告主DTO
     */
    @Override
    public AdvertisingMasterDTO getDTOById(Long masterId) {
        return super.getSqlSession().selectOne(getStatement("getDTOById"), masterId);
    }

    @Override
    public List<AdvertisingMaster> getByGroup(Long groupQrcodeId) {
        return getSessionTemplate().selectList(getStatement("getByGroup"), groupQrcodeId);
    }

    @Override
    public List<AdvertisingMasterDTO> getBrandMaster() {
        return getSessionTemplate().selectList(getStatement("getBrandMaster"));
    }

    @Override
    public Long getIdByUserLoginId(Long loginId) {
        return getSessionTemplate().selectOne(getStatement("getIdByUserLoginId"), loginId);
    }

    @Override
    public void updateMasterLoginId(Long masterId, Long loginId) {
        Map<String, Object> map = new HashMap<>();
        map.put("masterId", masterId);
        map.put("loginId", loginId);
        getSessionTemplate().update(getStatement("updateMasterLoginId"), map);
    }
}
