package com.pcloud.book.advertising.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

/**
 * 广告详情文件
 */
public class AdvertisingDetailFile extends BaseEntity{

    /**
     * 广告id
     */
    private Long adId;

    /**
     * 文件ID
     */
    private String fileId;

    /**
     * 文件转码状态
     */
    private Integer fileConvertState;
    /**
     *文件大小
     */
    private Long fileSize;
    /**
     *文件名称
     */
    private String fileName;
    /**
     *文件时长
     */
    private Long fileDuration;
    /**
     *文件路径
     */
    private String fileUrl;
    /**
     *文件试播秒数
     */
    private Long filePilotSecond;
    /**
     *文件试播路径
     */
    private String filePilotUrl;
    /**
     *文件试播结束提示
     */
    private String filePilotFinishTip;
    /**
     *文件标题
     */
    private String title;
    /**
     *封面
     */
    private String coverPic;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId == null ? null : fileId.trim();
    }

    public Integer getFileConvertState() {
        return fileConvertState;
    }

    public void setFileConvertState(Integer fileConvertState) {
        this.fileConvertState = fileConvertState;
    }

    public Long getFileSize() {
        return fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName == null ? null : fileName.trim();
    }

    public Long getFileDuration() {
        return fileDuration;
    }

    public void setFileDuration(Long fileDuration) {
        this.fileDuration = fileDuration;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl == null ? null : fileUrl.trim();
    }

    public Long getFilePilotSecond() {
        return filePilotSecond;
    }

    public void setFilePilotSecond(Long filePilotSecond) {
        this.filePilotSecond = filePilotSecond;
    }

    public String getFilePilotUrl() {
        return filePilotUrl;
    }

    public void setFilePilotUrl(String filePilotUrl) {
        this.filePilotUrl = filePilotUrl == null ? null : filePilotUrl.trim();
    }

    public String getFilePilotFinishTip() {
        return filePilotFinishTip;
    }

    public void setFilePilotFinishTip(String filePilotFinishTip) {
        this.filePilotFinishTip = filePilotFinishTip == null ? null : filePilotFinishTip.trim();
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public String getCoverPic() {
        return coverPic;
    }

    public void setCoverPic(String coverPic) {
        this.coverPic = coverPic == null ? null : coverPic.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public String toString() {
        return "AdvertisingDetailFile{" +
                "adId=" + adId +
                ", fileId='" + fileId + '\'' +
                ", fileConvertState=" + fileConvertState +
                ", fileSize=" + fileSize +
                ", fileName='" + fileName + '\'' +
                ", fileDuration=" + fileDuration +
                ", fileUrl='" + fileUrl + '\'' +
                ", filePilotSecond=" + filePilotSecond +
                ", filePilotUrl='" + filePilotUrl + '\'' +
                ", filePilotFinishTip='" + filePilotFinishTip + '\'' +
                ", title='" + title + '\'' +
                ", coverPic='" + coverPic + '\'' +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                '}';
    }
}