/**
 * 
 */
package com.pcloud.book.appeal.tool;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pcloud.book.appeal.dto.BookAppealDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2017年5月5日,下午4:33:43
 * @版本：1.0
 */
public class BookAppealTools {

	/**
	 * 组装编辑标识(去重)
	 */
	public static List<Long> listAdviserIds(List<Object> objects) throws BizException {
		Map<Long, Long> adviserIdMap = Maps.newHashMap();
		for (Object object : objects) {
			BookAppealDto bookAppealDto = (BookAppealDto) object;
			Long adviserId = bookAppealDto.getDeclarant();
			if (!adviserIdMap.containsKey(adviserId)) {
				adviserIdMap.put(adviserId, adviserId);
			}
		}
		return Lists.newArrayList(adviserIdMap.values());
	}
	
	/**
	 * 批量填充编辑名称
	 */
	public static void setAdviserNames(List<Object> objects, Map<Long, String> adviserNameMap) throws BizException {
		for (Object object : objects) {
			BookAppealDto bookAppealDto = (BookAppealDto) object;
			Long adviserId = bookAppealDto.getDeclarant();
			if (adviserNameMap.containsKey(adviserId)) {
				bookAppealDto.setDeclarantName(adviserNameMap.get(adviserId));
			} else {
				bookAppealDto.setDeclarantName("");
			}
		}
	}
	
}
