package com.pcloud.book.copyright.facade;

import com.pcloud.book.copyright.vo.BookAuthCodeUserVO;
import com.pcloud.book.copyright.vo.BookClickBuyRecordParam;
import com.pcloud.book.copyright.vo.CheckUserParam;
import com.pcloud.book.copyright.vo.ProvinceTop10VO;
import com.pcloud.book.copyright.vo.SixMonthCountVO;
import com.pcloud.book.copyright.vo.ThirtyDayCountVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;

import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author lily
 * @date 2018/12/3 10:59
 */
@Api(description = "版权验证用户")
public interface BookAuthUserFacade {

    @ApiOperation(value = "获取正版授权总人数", httpMethod = "GET")
    @RequestMapping(value = "getAuthUserCount", method = RequestMethod.GET)
    ResponseDto<BookAuthCodeUserVO> getAuthUserCount(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId,
                                                     @RequestParam("channelId") Long channelId, @RequestParam(value = "authBookType", required = false) Integer authBookType)
            throws PermissionException, BizException;

    @ApiOperation(value = "获取30天趋势图", httpMethod = "GET")
    @RequestMapping(value = "listThirtyDay", method = RequestMethod.GET)
    ResponseDto<List<ThirtyDayCountVO>> listThirtyDay(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId,
                                                      @RequestParam("channelId") Long channelId, @RequestParam(value = "province", required = false) String province,
                                                      @RequestParam(value = "authBookType", required = false) Integer authBookType)
            throws PermissionException, BizException;


    @ApiOperation(value = "6个月趋势图", httpMethod = "GET")
    @RequestMapping(value = "listSixMonth", method = RequestMethod.GET)
    ResponseDto<List<SixMonthCountVO>> listSixMonth(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId,
                                                    @RequestParam(value = "province", required = false) String province, @RequestParam(value = "authBookType", required = false) Integer authBookType)
            throws PermissionException, BizException;

    @ApiOperation(value = "省份排名前10(6个月/30天)", httpMethod = "GET")
    @RequestMapping(value = "listTop10ByBook", method = RequestMethod.GET)
    ResponseDto<List<ProvinceTop10VO>> listTop10ByBook(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId,
                                                       @RequestParam(value = "type", required = false) Integer type)
            throws PermissionException, BizException;


    @PostMapping("insertClickBuyRecord")
    @ApiOperation("新增点击购买链接记录")
    ResponseDto<?> insertClickBuyRecord(@CookieValue("userInfo") String userInfo, @RequestBody BookClickBuyRecordParam bookClickBuyRecordParam)
            throws BizException;

    @PostMapping("checkIsHaveAuth")
    @ApiOperation("校验用户是否授权过")
    ResponseDto<?> checkIsHaveAuth(@CookieValue("userInfo") String userInfo, @RequestBody CheckUserParam checkUserParam)
            throws BizException;
}
