package com.pcloud.book.group.facade;

import com.pcloud.book.group.entity.GroupAnnouncement;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

@Api(description = "群公告")
public interface GroupAnnouncementFacade {


    @ApiOperation("新增群公告")
    @PostMapping("createGroupAnnouncement")
    ResponseDto<?> createGroupAnnouncement(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群公告实体") GroupAnnouncement groupAnnouncement
    ) throws BizException, PermissionException;

    @ApiOperation("修改群公告")
    @PostMapping("updateGroupAnnouncement")
    ResponseDto<?> updateGroupAnnouncement(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群公告实体") GroupAnnouncement groupAnnouncement
    ) throws BizException, PermissionException;

    @ApiOperation("获取群公告")
    @GetMapping("getGroupAnnouncement")
    ResponseDto<?> getGroupAnnouncement(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "classifyId",required = false) @ApiParam("分类id") Long classifyId,
            @RequestParam(value = "bookGroupId",required = false) @ApiParam("社群码id") Long bookGroupId
    ) throws BizException, PermissionException;
}
