package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;

/**
 * 图书冻结
 *
 * @author lili
 * @date 2018/1/18 18:03
 */
public class BookFreezeDto extends BaseDto {

    /**
	 * 
	 */
	private static final long serialVersionUID = 3943934822582760541L;

	/**
     * 冻结标识
     */
    private Long id;

    /**
     * 图书标识
     */
    private Long bookId;

    /**
     * 冻结时间
     */
    private Date freezetime;

    /**
     * 冻结状态
     */
    private Integer freezeStatus;

    /**
     * 解冻时间
     */
    private Date thawTime;

    /**
     * 基金标识
     */
    private Long bookFundId;
    /**
     * 是否代理模式-新增于2018-8-6
     */
    private Integer proxyMode;

    /**
     * 转让方-新增于2018-8-6
     */
    private String transferor;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    public Date getThawTime() {
        return thawTime;
    }

    public void setThawTime(Date thawTime) {
        this.thawTime = thawTime;
    }

    public Long getBookFundId() {
        return bookFundId;
    }

    public void setBookFundId(Long bookFundId) {
        this.bookFundId = bookFundId;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    public Date getFreezetime() {
        return freezetime;
    }

    public void setFreezetime(Date freezetime) {
        this.freezetime = freezetime;
    }

    public Integer getProxyMode() {
        return proxyMode;
    }

    public void setProxyMode(Integer proxyMode) {
        this.proxyMode = proxyMode;
    }
    public String getTransferor() {
        return transferor;
    }

    public void setTransferor(String transferor) {
        this.transferor = transferor;
    }

    @Override
    public String toString() {
        return "BookFreezeDto{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", freezetime=" + freezetime +
                ", freezeStatus=" + freezeStatus +
                ", thawTime=" + thawTime +
                ", bookFundId=" + bookFundId +
                '}';
    }
}
