package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.dto.AdvertisingMasterDTO;
import com.pcloud.book.advertising.entity.AdvertisingMaster;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * Description 广告主数据访问层接口
 * Created by PENG on 2019/4/26.
 */
public interface AdvertisingMasterDao extends BaseDao<AdvertisingMaster> {

    /**
     * 获取所有广告主
     * @return
     */
    List<AdvertisingMasterDTO> getAllMaster();

    /**
     * 获取广告主DTO
     * @param masterId 广告主ID
     * @return
     */
    AdvertisingMasterDTO getDTOById(Long masterId);

    /**
     * 查微信群标记的广告主
     * @param groupQrcodeId
     * @return
     */
    List<AdvertisingMaster> getByGroup(Long groupQrcodeId);

    /**
     * 获取品牌方广告主
     * @return
     */
    List<AdvertisingMasterDTO> getBrandMaster();

    /**
     * 根据登录id查广告主id
     * @param loginId
     * @return
     */
    public Long getIdByUserLoginId(Long loginId);

    /**
     * 修改广告主登录id
     * @param masterId
     * @param loginId
     */
    public void updateMasterLoginId(Long masterId, Long loginId);
}
